/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public final class LocationsUtil {
    private LocationsUtil() {
    }

    public static EObject add(IReferenceLocation location_p, EObject element_p) {
        EObject result = null;
        EObject source = location_p.getElement();
        EReference reference = location_p.getReference();
        Object originalValue = source.eGet((EStructuralFeature)reference);
        if (FeatureMapUtil.isMany((EObject)source, (EStructuralFeature)reference)) {
            List values = (List)originalValue;
            if (!values.contains(element_p)) {
                values.add(element_p);
            }
        } else {
            source.eSet((EStructuralFeature)reference, (Object)element_p);
            if (originalValue instanceof EObject) {
                result = (EObject)originalValue;
            }
        }
        return result;
    }

    public static List<EObject> getInvolvedElements(ILocation location_p) {
        ModelsUtil.ROrderedSet<EObject> result = new ModelsUtil.ROrderedSet<EObject>();
        if (location_p != null) {
            for (IAtomicLocation iAtomicLocation : location_p.getAtomicContents()) {
                EObject element;
                if (!(iAtomicLocation instanceof IElementRelativeLocation) || (element = ((IElementRelativeLocation)iAtomicLocation).getElement()) == null) continue;
                result.add(element);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static List<EObject> getMergeTargets(ILocation location_p) {
        ModelsUtil.ROrderedSet<EObject> result = new ModelsUtil.ROrderedSet<EObject>();
        if (location_p != null) {
            for (IAtomicLocation iAtomicLocation : location_p.getAtomicContents()) {
                if (!iAtomicLocation.supportsMerge()) continue;
                if (iAtomicLocation instanceof IElementLocation) {
                    EObject element = ((IElementLocation)iAtomicLocation).getElement();
                    if (element == null) continue;
                    result.add(element);
                    continue;
                }
                if (!(iAtomicLocation instanceof IElementMappingLocation)) continue;
                IElementMappingLocation mappingLocation = (IElementMappingLocation)iAtomicLocation;
                result.addAll(mappingLocation.getModelElements());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static List<EObject> getMergeTargets(IPatternApplication application_p) {
        ModelsUtil.ROrderedSet<EObject> result = new ModelsUtil.ROrderedSet<EObject>();
        if (application_p.getPattern() != null) {
            for (ILocation iLocation : application_p.getLocations()) {
                List<EObject> roleElements = LocationsUtil.getMergeTargets(iLocation);
                result.addAll(roleElements);
            }
        }
        return result;
    }

    public static List<EObject> getRoleElements(IPatternApplication application_p) {
        ModelsUtil.ROrderedSet<EObject> result = new ModelsUtil.ROrderedSet<EObject>();
        for (ILocation iLocation : application_p.getLocations()) {
            List<EObject> roleElements = LocationsUtil.getInvolvedElements(iLocation);
            result.addAll(roleElements);
        }
        return result;
    }
}

