/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.api.status;

import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;

public abstract class AbstractStatus
implements IEvaluationStatus {
    private final boolean _isOk;
    private final boolean _hasWarnings;
    protected final String _description;
    private boolean _mutable;

    public AbstractStatus(boolean isOk_p, String description_p) {
        this(isOk_p, false, description_p);
    }

    public AbstractStatus(boolean isOk_p, boolean hasWarnings_p, String description_p) {
        this(isOk_p, hasWarnings_p, description_p, false);
    }

    public AbstractStatus(boolean isOk_p, boolean hasWarnings_p, String description_p, boolean mutable_p) {
        this._isOk = isOk_p;
        this._description = description_p;
        this._hasWarnings = hasWarnings_p;
        this._mutable = mutable_p;
    }

    public void freeze() {
        this._mutable = false;
    }

    private String getDefaultDescription(boolean isOk_p, boolean hasWarnings_p) {
        String result = isOk_p ? (hasWarnings_p ? Messages.BasicStatus_Warnings : Messages.BasicStatus_Success) : Messages.BasicStatus_Failure;
        return result;
    }

    @Override
    public String getDescription() {
        String result = this._description;
        if (result == null || result.length() == 0) {
            result = this.getDefaultDescription(this._isOk, this._hasWarnings);
        }
        return result;
    }

    @Override
    public boolean hasWarnings() {
        return this._hasWarnings;
    }

    public boolean isMutable() {
        return this._mutable;
    }

    @Override
    public boolean isOk() {
        return this._isOk;
    }
}

