/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.launcher.JUnitRuntimeClasspathEntry;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.osgi.framework.Bundle;

public class JUnitLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private boolean fKeepAlive = false;
    private int fPort;
    private IJavaElement[] fTestElements;
    private static final String DEFAULT = "<default>";

    public String showCommandLine(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(configuration, launch, mode, monitor);
            if (runConfig == null) {
                return "";
            }
            IVMRunner runner = this.getVMRunner(configuration, mode);
            String cmdLine = runner.showCommandLine(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return "";
            }
            String string = cmdLine;
            return string;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration configuration, ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException {
        IJavaElement testTarget;
        VMRunnerConfiguration runConfig = null;
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 5);
        if (monitor.isCanceled()) {
            return null;
        }
        if ("runQuietly".equals(mode)) {
            launch.setAttribute("org.eclipse.jdt.junit.NO_DISPLAY", "true");
            mode = "run";
        }
        monitor.subTask(JUnitMessages.JUnitLaunchConfigurationDelegate_verifying_attriburtes_description);
        try {
            this.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() != 8) throw e;
            monitor.setCanceled(true);
            monitor.worked(1);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        this.fKeepAlive = "debug".equals(mode) && configuration.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        this.fPort = this.evaluatePort();
        launch.setAttribute("org.eclipse.jdt.junit.PORT", String.valueOf(this.fPort));
        ITestKind testKind = this.getTestRunnerKind(configuration);
        IJavaProject javaProject = this.getJavaProject(configuration);
        this.fTestElements = "org.eclipse.jdt.junit.loader.junit3".equals(testKind.getId()) || "org.eclipse.jdt.junit.loader.junit4".equals(testKind.getId()) ? this.evaluateTests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : ((testTarget = this.getTestTarget(configuration, javaProject)) instanceof IPackageFragment || testTarget instanceof IPackageFragmentRoot || testTarget instanceof IJavaProject ? new IJavaElement[]{testTarget} : this.evaluateTests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        String mainTypeName = this.verifyMainTypeName(configuration);
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String[] envp = this.getEnvironment(configuration);
        ArrayList<String> vmArguments = new ArrayList<String>();
        ArrayList<String> programArguments = new ArrayList<String>();
        this.collectExecutionArguments(configuration, vmArguments, programArguments);
        vmArguments.addAll(Arrays.asList(DebugPlugin.parseArguments((String)this.getVMArguments(configuration, mode))));
        if (JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            vmArguments.add("--add-modules=ALL-MODULE-PATH");
        }
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[][] classpathAndModulepath = this.getClasspathAndModulepath(configuration);
        String[] classpath = classpathAndModulepath[0];
        String[] modulepath = classpathAndModulepath[1];
        if ("org.eclipse.jdt.junit.loader.junit5".equals(this.getTestRunnerKind(configuration).getId()) && !configuration.getAttribute("org.eclipse.jdt.junit.DONT_ADD_MISSING_JUNIT5_DEPENDENCY", false)) {
            int length;
            String entryString;
            JUnitRuntimeClasspathEntry x;
            if (!Arrays.stream(classpath).anyMatch(s -> s.contains("junit-platform-launcher") || s.contains("org.junit.platform.launcher"))) {
                try {
                    x = new JUnitRuntimeClasspathEntry("junit-platform-launcher", null);
                    entryString = new ClasspathLocalizer(Platform.inDevelopmentMode()).entryString(x);
                    length = classpath.length;
                    String[] stringArray = classpath;
                    classpath = new String[length + 1];
                    System.arraycopy(stringArray, 0, classpath, 0, length);
                    classpath[length] = entryString;
                }
                catch (IOException | URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", 4, "", (Throwable)e));
                }
            }
            if (!Arrays.stream(classpath).anyMatch(s -> s.contains("junit-jupiter-engine") || s.contains("org.junit.jupiter.engine"))) {
                try {
                    x = new JUnitRuntimeClasspathEntry("junit-jupiter-engine", null);
                    entryString = new ClasspathLocalizer(false).entryString(x);
                    length = classpath.length;
                    String[] stringArray = classpath;
                    classpath = new String[length + 1];
                    System.arraycopy(stringArray, 0, classpath, 0, length);
                    classpath[length] = entryString;
                }
                catch (IOException | URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", 4, "", (Throwable)e));
                }
            }
            if (!Arrays.stream(classpath).anyMatch(s -> s.contains("junit-jupiter-api") || s.contains("org.junit.jupiter.api"))) {
                try {
                    x = new JUnitRuntimeClasspathEntry("junit-jupiter-api", null);
                    entryString = new ClasspathLocalizer(false).entryString(x);
                    length = classpath.length;
                    String[] stringArray = classpath;
                    classpath = new String[length + 1];
                    System.arraycopy(stringArray, 0, classpath, 0, length);
                    classpath[length] = entryString;
                }
                catch (IOException | URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", 4, "", (Throwable)e));
                }
            }
        }
        runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setVMArguments(vmArguments.toArray(new String[vmArguments.size()]));
        runConfig.setProgramArguments(programArguments.toArray(new String[programArguments.size()]));
        runConfig.setEnvironment(envp);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setPreviewEnabled(this.supportsPreviewFeatures(configuration));
        if (!JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration)) {
            runConfig.setBootClassPath(this.getBootpath(configuration));
        } else {
            runConfig.setModulepath(modulepath);
            if (!configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true)) {
                runConfig.setOverrideDependencies(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, ""));
            } else {
                runConfig.setOverrideDependencies(this.getModuleCLIOptions(configuration));
            }
        }
        if (!monitor.isCanceled()) return runConfig;
        return null;
        finally {
            monitor.worked(1);
        }
    }

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(configuration, launch, mode, monitor);
            if (monitor.isCanceled() || runConfig == null) {
                return;
            }
            IVMRunner runner = this.getVMRunner(configuration, mode);
            monitor.subTask(JUnitMessages.JUnitLaunchConfigurationDelegate_create_source_locator_description);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            this.fTestElements = null;
            monitor.done();
        }
    }

    private int evaluatePort() throws CoreException {
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_no_socket, null, 118);
        }
        return port;
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (javaProject == null || !javaProject.exists()) {
                this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_invalidproject, null, 107);
            }
            ITestKind testKind = this.getTestRunnerKind(configuration);
            boolean isJUnit4Configuration = "org.eclipse.jdt.junit.loader.junit4".equals(testKind.getId());
            boolean isJUnit5Configuration = "org.eclipse.jdt.junit.loader.junit5".equals(testKind.getId());
            if (!isJUnit5Configuration && !CoreTestSearchEngine.hasTestCaseType(javaProject)) {
                this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junitnotonpath, null, 10004);
            }
            if (isJUnit4Configuration && !CoreTestSearchEngine.hasJUnit4TestAnnotation(javaProject)) {
                this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junit4notonpath, null, 10004);
            }
            if (isJUnit5Configuration && !CoreTestSearchEngine.hasJUnit5TestAnnotation(javaProject)) {
                String msg = Messages.format(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junit5notonpath, "org.junit.platform.commons.annotation.Testable");
                this.abort(msg, null, 10004);
            }
        }
        finally {
            monitor.done();
        }
    }

    private ITestKind getTestRunnerKind(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind(configuration);
        if (testKind.isNull()) {
            testKind = TestKindRegistry.getDefault().getKind("org.eclipse.jdt.junit.loader.junit3");
        }
        return testKind;
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.eclipse.jdt.internal.junit.runner.RemoteTestRunner";
    }

    protected IMember[] evaluateTests(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IJavaElement testTarget = this.getTestTarget(configuration, javaProject);
        String testMethodName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        if (testMethodName.length() > 0 && testTarget instanceof IType) {
            return new IMember[]{((IType)testTarget).getMethod(testMethodName, new String[0])};
        }
        HashSet<IType> result = new HashSet<IType>();
        ITestKind testKind = this.getTestRunnerKind(configuration);
        testKind.getFinder().findTestsInContainer(testTarget, result, monitor);
        if (result.isEmpty()) {
            String msg = Messages.format(JUnitMessages.JUnitLaunchConfigurationDelegate_error_notests_kind, testKind.getDisplayName());
            this.abort(msg, null, 101);
        }
        return result.toArray(new IMember[result.size()]);
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List<String> vmArguments, List<String> programArguments) throws CoreException {
        String excludeTags;
        boolean hasExcludeTags;
        int n;
        String includeTags;
        boolean hasIncludeTags;
        String uniqueId;
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        vmArguments.addAll(Arrays.asList(execArgs.getVMArgumentsArray()));
        programArguments.addAll(Arrays.asList(execArgs.getProgramArgumentsArray()));
        boolean isJUnit5 = "org.eclipse.jdt.junit.loader.junit5".equals(this.getTestRunnerKind(configuration).getId());
        boolean isModularProject = JavaRuntime.isModularProject((IJavaProject)this.getJavaProject(configuration));
        String addOpensTargets = isModularProject ? (isJUnit5 ? (JUnitLaunchConfigurationDelegate.isOnModulePath(this.getJavaProject(configuration), "org.junit.jupiter.api.Test") ? "org.junit.platform.commons,ALL-UNNAMED" : "ALL-UNNAMED") : (JUnitLaunchConfigurationDelegate.isOnModulePath(this.getJavaProject(configuration), "junit.framework.TestCase") ? "junit,ALL-UNNAMED" : "ALL-UNNAMED")) : null;
        ArrayList<String> addOpensVmArgs = new ArrayList<String>();
        programArguments.add("-version");
        programArguments.add("3");
        programArguments.add("-port");
        programArguments.add(String.valueOf(this.fPort));
        if (this.fKeepAlive) {
            programArguments.add(0, "-keepalive");
        }
        ITestKind testRunnerKind = this.getTestRunnerKind(configuration);
        programArguments.add("-testLoaderClass");
        programArguments.add(testRunnerKind.getLoaderClassName());
        programArguments.add("-loaderpluginname");
        programArguments.add(testRunnerKind.getLoaderPluginId());
        IJavaElement[] testElements = this.fTestElements;
        if (testElements.length == 1) {
            IJavaElement testElement = testElements[0];
            if (testElement instanceof IMethod) {
                IMethod method = (IMethod)testElement;
                programArguments.add("-test");
                programArguments.add(String.valueOf(method.getDeclaringType().getFullyQualifiedName()) + ':' + method.getElementName());
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, (IJavaElement)method, configuration);
            } else if (testElement instanceof IType) {
                IType type = (IType)testElement;
                programArguments.add("-classNames");
                programArguments.add(type.getFullyQualifiedName());
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, (IJavaElement)type, configuration);
            } else if (testElement instanceof IPackageFragment || testElement instanceof IPackageFragmentRoot || testElement instanceof IJavaProject) {
                HashSet<String> pkgNames = new HashSet<String>();
                String fileName2 = this.createPackageNamesFile(testElement, testRunnerKind, pkgNames);
                programArguments.add("-packageNameFile");
                programArguments.add(fileName2);
                for (String pkgName : pkgNames) {
                    if (DEFAULT.equals(pkgName)) continue;
                    this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, pkgName, configuration);
                }
            } else {
                this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_wrong_input, null, 101);
            }
        } else if (testElements.length > 1) {
            String fileName = this.createTestNamesFile(testElements);
            programArguments.add("-testNameFile");
            programArguments.add(fileName);
            IJavaElement[] iJavaElementArray = testElements;
            int pkgName = testElements.length;
            int fileName2 = 0;
            while (fileName2 < pkgName) {
                IJavaElement testElement = iJavaElementArray[fileName2];
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, testElement, configuration);
                ++fileName2;
            }
        }
        String testFailureNames = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
        if (testFailureNames.length() > 0) {
            programArguments.add("-testfailures");
            programArguments.add(testFailureNames);
        }
        if (!(uniqueId = configuration.getAttribute("org.eclipse.jdt.junit.TEST_UNIQUE_ID", "")).trim().isEmpty()) {
            programArguments.add("-uniqueId");
            programArguments.add(uniqueId);
        }
        if ((hasIncludeTags = configuration.getAttribute("org.eclipse.jdt.junit.HAS_INCLUDE_TAGS", false)) && (includeTags = configuration.getAttribute("org.eclipse.jdt.junit.INCLUDE_TAGS", "")) != null && !includeTags.trim().isEmpty()) {
            String[] tags;
            String[] stringArray = tags = includeTags.split(",");
            n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                programArguments.add("--include-tag");
                programArguments.add(tag.trim());
                ++n2;
            }
        }
        if ((hasExcludeTags = configuration.getAttribute("org.eclipse.jdt.junit.HAS_EXCLUDE_TAGS", false)) && (excludeTags = configuration.getAttribute("org.eclipse.jdt.junit.EXCLUDE_TAGS", "")) != null && !excludeTags.trim().isEmpty()) {
            String[] tags;
            String[] stringArray = tags = excludeTags.split(",");
            int n3 = tags.length;
            n = 0;
            while (n < n3) {
                String tag = stringArray[n];
                programArguments.add("--exclude-tag");
                programArguments.add(tag.trim());
                ++n;
            }
        }
        if (addOpensTargets != null) {
            vmArguments.addAll(addOpensVmArgs);
        }
    }

    private static boolean isOnModulePath(IJavaProject javaProject, String typeToCheck) {
        IType type;
        block3: {
            try {
                type = javaProject.findType(typeToCheck);
                if (type != null) break block3;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        IClasspathEntry resolvedClasspathEntry = packageFragmentRoot.getResolvedClasspathEntry();
        return Arrays.stream(resolvedClasspathEntry.getExtraAttributes()).anyMatch(p -> "module".equals(p.getName()) && "true".equals(p.getValue()));
    }

    private void collectAddOpensVmArgs(String addOpensTargets, List<String> addOpensVmArgs, IJavaElement javaElem, ILaunchConfiguration configuration) throws CoreException {
        IPackageFragment pkg;
        if (addOpensTargets != null && (pkg = this.getParentPackageFragment(javaElem)) != null) {
            String pkgName = pkg.getElementName();
            this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, pkgName, configuration);
        }
    }

    private void collectAddOpensVmArgs(String addOpensTargets, List<String> addOpensVmArgs, String pkgName, ILaunchConfiguration configuration) throws CoreException {
        if (addOpensTargets != null) {
            IJavaProject javaProject = this.getJavaProject(configuration);
            String sourceModuleName = javaProject.getModuleDescription().getElementName();
            addOpensVmArgs.add("--add-opens");
            addOpensVmArgs.add(String.valueOf(sourceModuleName) + "/" + pkgName + "=" + addOpensTargets);
        }
    }

    private IPackageFragment getParentPackageFragment(IJavaElement element) {
        IJavaElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof IPackageFragment) {
                return (IPackageFragment)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private String createPackageNamesFile(IJavaElement testContainer, ITestKind testRunnerKind, Set<String> pkgNames) throws CoreException {
        try {
            File file = File.createTempFile("packageNames", ".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                if (testContainer instanceof IPackageFragment) {
                    this.addAllSubPackageFragments((IPackageFragment)testContainer, pkgNames);
                } else if (testContainer instanceof IPackageFragmentRoot) {
                    this.addAllPackageFragments((IPackageFragmentRoot)testContainer, pkgNames);
                } else if (testContainer instanceof IJavaProject) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)testContainer).getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n2];
                        if (!pkgFragmentRoot.isExternal() && !pkgFragmentRoot.isArchive()) {
                            this.addAllPackageFragments(pkgFragmentRoot, pkgNames);
                        }
                        ++n2;
                    }
                } else {
                    this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_wrong_input, null, 101);
                }
                if (pkgNames.isEmpty()) {
                    String msg = Messages.format(JUnitMessages.JUnitLaunchConfigurationDelegate_error_notests_kind, testRunnerKind.getDisplayName());
                    this.abort(msg, null, 101);
                } else {
                    for (String pkgName : pkgNames) {
                        bw.write(pkgName);
                        bw.newLine();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getAbsolutePath();
        }
        catch (IOException | JavaModelException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", 4, "", e));
        }
    }

    private Set<String> addAllPackageFragments(IPackageFragmentRoot pkgFragmentRoot, Set<String> pkgNames) throws JavaModelException {
        IJavaElement[] iJavaElementArray = pkgFragmentRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IPackageFragment && ((IPackageFragment)child).hasChildren()) {
                pkgNames.add(this.getPackageName(child.getElementName()));
            }
            ++n2;
        }
        return pkgNames;
    }

    private void addAllSubPackageFragments(IPackageFragment pkgFragment, Set<String> pkgNames) throws JavaModelException {
        String elementName = this.getPackageName(pkgFragment.getElementName());
        IPackageFragmentRoot pkgFragmentRoot = (IPackageFragmentRoot)pkgFragment.getParent();
        IJavaElement[] iJavaElementArray = pkgFragmentRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IPackageFragment && this.getPackageName(((IPackageFragment)child).getElementName()).startsWith(elementName) && ((IPackageFragment)child).hasChildren()) {
                pkgNames.add(this.getPackageName(((IPackageFragment)child).getElementName()));
            }
            ++n2;
        }
    }

    private String getPackageName(String elementName) {
        if (elementName.isEmpty()) {
            return DEFAULT;
        }
        return elementName;
    }

    private String createTestNamesFile(IJavaElement[] testElements) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                IJavaElement[] iJavaElementArray = testElements;
                int n = testElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement testElement = iJavaElementArray[n2];
                    if (testElement instanceof IType) {
                        IType type = (IType)testElement;
                        String testName = type.getFullyQualifiedName();
                        bw.write(testName);
                        bw.newLine();
                    } else {
                        this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_wrong_input, null, 101);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", 4, "", (Throwable)e));
        }
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        String[][] cpmp = super.getClasspathAndModulepath(configuration);
        String[] cp = cpmp[0];
        ITestKind kind = this.getTestRunnerKind(configuration);
        List<String> junitEntries = new ClasspathLocalizer(Platform.inDevelopmentMode()).localizeClasspath(kind);
        String[] classPath = new String[cp.length + junitEntries.size()];
        Object[] jea = junitEntries.toArray();
        System.arraycopy(cp, 0, classPath, 0, cp.length);
        System.arraycopy(jea, 0, classPath, cp.length, jea.length);
        cpmp[0] = classPath;
        return cpmp;
    }

    @Deprecated
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] cp = super.getClasspath(configuration);
        ITestKind kind = this.getTestRunnerKind(configuration);
        List<String> junitEntries = new ClasspathLocalizer(Platform.inDevelopmentMode()).localizeClasspath(kind);
        String[] classPath = new String[cp.length + junitEntries.size()];
        Object[] jea = junitEntries.toArray();
        System.arraycopy(cp, 0, classPath, 0, cp.length);
        System.arraycopy(jea, 0, classPath, cp.length, jea.length);
        return classPath;
    }

    private final IJavaElement getTestTarget(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        IType type;
        String containerHandle = configuration.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        if (containerHandle.length() != 0) {
            IJavaElement element = JavaCore.create((String)containerHandle);
            if (element == null || !element.exists()) {
                this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_input_element_deosn_not_exist, null, 101);
            }
            return element;
        }
        String testTypeName = this.getMainTypeName(configuration);
        if (testTypeName != null && testTypeName.length() != 0 && (type = javaProject.findType(testTypeName)) != null && type.exists()) {
            return type;
        }
        this.abort(JUnitMessages.JUnitLaunchConfigurationDelegate_input_type_does_not_exist, null, 101);
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit.core", code, message, exception));
    }

    private static class ClasspathLocalizer {
        private boolean fInDevelopmentMode;

        public ClasspathLocalizer(boolean inDevelopmentMode) {
            this.fInDevelopmentMode = inDevelopmentMode;
        }

        public List<String> localizeClasspath(ITestKind kind) {
            JUnitRuntimeClasspathEntry[] entries = kind.getClasspathEntries();
            ArrayList<String> junitEntries = new ArrayList<String>();
            JUnitRuntimeClasspathEntry[] jUnitRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                JUnitRuntimeClasspathEntry entrie = jUnitRuntimeClasspathEntryArray[n2];
                try {
                    this.addEntry(junitEntries, entrie);
                }
                catch (IOException | URISyntaxException exception) {
                    Assert.isTrue((boolean)false, (String)(String.valueOf(entrie.getPluginId()) + " is available (required JAR)"));
                }
                ++n2;
            }
            return junitEntries;
        }

        private void addEntry(List<String> junitEntries, JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException, URISyntaxException {
            String entryString = this.entryString(entry);
            if (entryString != null) {
                junitEntries.add(entryString);
            }
        }

        private String entryString(JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException, URISyntaxException {
            if (this.inDevelopmentMode()) {
                try {
                    return this.localURL(entry.developmentModeEntry());
                }
                catch (IOException iOException) {}
            }
            return this.localURL(entry);
        }

        private boolean inDevelopmentMode() {
            return this.fInDevelopmentMode;
        }

        private String localURL(JUnitRuntimeClasspathEntry jar) throws IOException, MalformedURLException, URISyntaxException {
            URL url;
            Bundle bundle = JUnitCorePlugin.getDefault().getBundle(jar.getPluginId());
            if (jar.getPluginRelativePath() == null) {
                String bundleClassPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
                URL uRL = url = bundleClassPath != null ? bundle.getEntry(bundleClassPath) : null;
                if (url == null) {
                    url = bundle.getEntry("/");
                }
            } else {
                url = bundle.getEntry(jar.getPluginRelativePath());
            }
            if (url == null) {
                throw new IOException();
            }
            return URIUtil.toFile((URI)URIUtil.toURI((URL)FileLocator.toFileURL((URL)url))).getAbsolutePath();
        }
    }
}

