/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.ocl.AbstractEvaluationEnvironment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LazyExtentMap;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EvaluationEnvironmentWithHiddenOpposites;
import org.eclipse.ocl.ecore.VoidType;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.internal.OCLEcorePlugin;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.UnicodeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEvaluationEnvironment
extends AbstractEvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>
implements EvaluationEnvironment.Enumerations<EEnumLiteral>,
EvaluationEnvironmentWithHiddenOpposites {
    private boolean mustCheckOperationReflectionConsistency = true;
    private final EcoreEnvironmentFactory factory;
    private final OppositeEndFinder oppositeEndFinder;

    @Deprecated
    public EcoreEvaluationEnvironment() {
        this((EcoreEnvironmentFactory)null);
    }

    public EcoreEvaluationEnvironment(EcoreEnvironmentFactory factory) {
        this.factory = factory;
        this.oppositeEndFinder = factory != null ? factory.getOppositeEndFinder() : null;
    }

    public EcoreEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
        EcoreEvaluationEnvironment ecoreParent = (EcoreEvaluationEnvironment)parent;
        this.factory = ecoreParent.factory;
        this.oppositeEndFinder = ecoreParent.oppositeEndFinder;
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        if (InvocationBehavior.INSTANCE.appliesTo(operation)) {
            EList arguments = args.length == 0 ? ECollections.emptyEList() : new BasicEList.UnmodifiableEList(args.length, args);
            try {
                Object result;
                Exception checkFailure;
                if (this.mustCheckOperationReflectionConsistency && (checkFailure = this.checkOperationReflectionConsistency(source)) != null) {
                    EClass operationClass = operation.getEContainingClass();
                    EPackage operationPackage = operationClass.getEPackage();
                    OCLEcorePlugin.warning(24, OCLMessages.bind((String)OCLMessages.NoOperationReflection_WARNING_, (Object)(String.valueOf(operationPackage.getName()) + "::" + operationClass.getName())), checkFailure);
                    result = ((EOperation.Internal)operation).getInvocationDelegate().dynamicInvoke((InternalEObject)source, arguments);
                } else {
                    result = ((EObject)source).eInvoke(operation, arguments);
                }
                return this.coerceValue((ETypedElement)operation, result, true);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.coerceValue((ETypedElement)operation, super.callOperation((Object)operation, opcode, source, args), true);
    }

    protected Method getJavaMethodFor(EOperation operation, Object receiver) {
        Method result = null;
        String operName = operation.getName();
        int opcode = OCLStandardLibraryUtil.getOperationCode((String)operName);
        switch (opcode) {
            case 1: {
                operName = "plus";
                break;
            }
            case 2: {
                operName = "minus";
                break;
            }
            case 3: {
                operName = "times";
                break;
            }
            case 4: {
                operName = "divide";
                break;
            }
            case 67: {
                operName = "lessThan";
                break;
            }
            case 69: {
                operName = "lessThanEqual";
                break;
            }
            case 68: {
                operName = "greaterThan";
                break;
            }
            case 70: {
                operName = "greaterThanEqual";
            }
        }
        EClass container = operation.getEContainingClass();
        Class containerClass = container.getInstanceClass();
        EList parms = operation.getEParameters();
        Class[] javaParms = new Class[parms.size()];
        int i = 0;
        int n = parms.size();
        while (i < n) {
            EParameter parm = (EParameter)parms.get(i);
            javaParms[i] = parm.isMany() ? EList.class : parm.getEType().getInstanceClass();
            ++i;
        }
        try {
            result = containerClass.getMethod(operName, javaParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    protected Object getInvalidResult() {
        return OCLStandardLibraryImpl.INVALID;
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        Tuple tuple;
        if (target instanceof EObject) {
            EObject etarget = (EObject)target;
            if (etarget.eClass().getEAllStructuralFeatures().contains((Object)property)) {
                EClassifier oclType = UMLReflectionImpl.INSTANCE.getOCLType(property);
                if (oclType instanceof VoidType) {
                    return null;
                }
                return this.coerceValue((ETypedElement)property, etarget.eGet(property), true);
            }
        } else if (target instanceof Tuple && (tuple = (Tuple)target).getTupleType().oclProperties().contains((Object)property)) {
            return tuple.getValue((Object)property);
        }
        throw new IllegalArgumentException();
    }

    protected static CollectionKind getCollectionKind(ETypedElement element) {
        EClassifier oclType = UMLReflectionImpl.INSTANCE.getOCLType(element);
        CollectionKind result = null;
        if (oclType instanceof CollectionType) {
            result = ((CollectionType)oclType).getKind();
            ObjectUtil.dispose((Object)oclType);
        }
        return result;
    }

    protected Object coerceValue(ETypedElement element, Object value, boolean copy) {
        CollectionKind kind = EcoreEvaluationEnvironment.getCollectionKind(element);
        if (kind != null) {
            if (value instanceof Collection) {
                return copy ? CollectionUtil.createNewCollection((CollectionKind)kind, (Collection)((Collection)value)) : value;
            }
            Collection result = CollectionUtil.createNewCollection((CollectionKind)kind);
            result.add(value);
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty() ? null : collection.iterator().next();
        }
        return value;
    }

    public Object navigateAssociationClass(EClassifier associationClass, EStructuralFeature navigationSource, Object target) throws IllegalArgumentException {
        if (target instanceof EObject) {
            EObject etarget = (EObject)target;
            EReference ref = this.getAssociationClassReference(etarget, (EClass)associationClass);
            if (etarget.eClass().getEAllStructuralFeatures().contains((Object)ref)) {
                return etarget.eGet((EStructuralFeature)ref);
            }
        }
        throw new IllegalArgumentException();
    }

    private EReference getAssociationClassReference(EObject context, EClass associationClass) {
        EReference result = null;
        StringBuffer nameBuf = new StringBuffer(associationClass.getName());
        UnicodeSupport.setCodePointAt((StringBuffer)nameBuf, (int)0, (int)Character.toLowerCase(nameBuf.codePointAt(0)));
        String name = nameBuf.toString();
        for (EReference next : context.eClass().getEAllReferences()) {
            if (!name.equals(next.getName()) || associationClass != next.getEReferenceType()) continue;
            result = next;
            break;
        }
        return result;
    }

    public Tuple<EOperation, EStructuralFeature> createTuple(EClassifier type, Map<EStructuralFeature, Object> values) {
        TupleType tupleType = (TupleType)type;
        return new AbstractEvaluationEnvironment.AbstractTuple<EOperation, EStructuralFeature>(tupleType, values){

            protected String getName(EStructuralFeature part) {
                return part.getName();
            }
        };
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        if (object instanceof EObject) {
            return new LazyExtentMap<EClass, EObject>((EObject)object){

                protected boolean isInstance(EClass cls, EObject element) {
                    return cls.isInstance((Object)element);
                }
            };
        }
        return Collections.emptyMap();
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        if (object.getClass() == Integer.class && classifier.getInstanceClass() == Double.class) {
            return Boolean.TRUE;
        }
        if (classifier instanceof AnyType) {
            return Boolean.TRUE;
        }
        return classifier.isInstance(object);
    }

    public boolean isTypeOf(Object object, EClassifier classifier) {
        if (classifier instanceof EClass && object instanceof EObject) {
            return ((EObject)object).eClass() == classifier;
        }
        if (!(object instanceof EObject) && !(classifier instanceof EClass)) {
            return object.getClass() == classifier.getInstanceClass();
        }
        return false;
    }

    public EClassifier getType(Object object) {
        return EcoreEnvironmentFactory.oclType(object);
    }

    public Enumerator getValue(EEnumLiteral enumerationLiteral) {
        return enumerationLiteral.getInstance();
    }

    public void setOperationReflectionCheckDisabled(boolean checkDisabled) {
        this.mustCheckOperationReflectionConsistency = !checkDisabled;
    }

    protected Exception checkOperationReflectionConsistency(Object source) {
        try {
            source.getClass().getDeclaredMethod("eInvoke", Integer.TYPE, EList.class);
            return null;
        }
        catch (NoSuchMethodException e) {
            return e;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object navigateOppositeProperty(EReference property, Object target) throws IllegalArgumentException {
        Bag result = null;
        if (property.isContainment()) {
            Object propertyValue;
            EObject resultCandidate = ((EObject)target).eContainer();
            if (resultCandidate != null && property.getEContainingClass().isInstance((Object)resultCandidate) && ((propertyValue = resultCandidate.eGet((EStructuralFeature)property)) == target || propertyValue instanceof Collection && ((Collection)propertyValue).contains(target))) {
                result = CollectionUtil.createNewBag(Collections.singleton(resultCandidate));
            }
        } else if (this.oppositeEndFinder != null) {
            result = this.oppositeEndFinder.navigateOppositePropertyWithForwardScope(property, (EObject)target);
        }
        return result;
    }
}

