/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.kitalpha.ad.af.coredomain.af.model.AF;
import org.polarsys.kitalpha.ad.af.coredomain.af.model.AfPackage;
import org.polarsys.kitalpha.ad.af.coredomain.af.model.util.AfAdapterFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.viewpoint.PlatformViewpointHelper;

public class AFViewpointRegistrationManager {
    public static void registerNewGeneratedViewpoint(String afBundleID, String afModelFolder, String afModelName, List<Viewpoint> viewpoints) throws IOException, InvocationException {
        if (!afModelName.endsWith(".af")) {
            afModelName = String.valueOf(afModelName) + ".af";
        }
        String uris = "/" + afBundleID + "/" + afModelFolder + "/" + afModelName;
        AFViewpointRegistrationManager.registerNewGeneratedViewpoint(uris, viewpoints);
    }

    public static void registerNewGeneratedViewpoint(String afResourceStringUri, Viewpoint viewpoint) throws IOException, InvocationException {
        ArrayList<Viewpoint> vpList = new ArrayList<Viewpoint>();
        vpList.add(viewpoint);
        AFViewpointRegistrationManager.registerNewGeneratedViewpoint(afResourceStringUri, vpList);
    }

    public static void registerNewGeneratedViewpoint(String afResourceStringUri, List<Viewpoint> viewpoints) throws IOException, InvocationException {
        EObject modelRootElement;
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new AfAdapterFactory(), (CommandStack)new BasicCommandStack());
        Resource resource = domain.createResource(afResourceStringUri);
        resource.load(null);
        EList content = resource.getContents();
        if (content != null && content.size() > 0 && (modelRootElement = (EObject)content.get(0)) instanceof AF) {
            AF af = (AF)modelRootElement;
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)af);
            CompoundCommand allAddCommands = new CompoundCommand();
            for (Viewpoint viewpoint : viewpoints) {
                org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint afViewpoint = AFViewpointRegistrationManager.getAFViewpoint(viewpoint, resource.getResourceSet());
                if (afViewpoint != null) {
                    Command addCommand = AddCommand.create((EditingDomain)editingDomain, (Object)af, (Object)AfPackage.eINSTANCE.getAF_Viewpoints(), (Object)afViewpoint);
                    allAddCommands.append(addCommand);
                    continue;
                }
                throw new InvocationException("Unable to locate core domain Viewpoint");
            }
            editingDomain.getCommandStack().execute((Command)allAddCommands);
        }
        resource.save(Collections.EMPTY_MAP);
        resource.unload();
    }

    public static org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint getAFViewpoint(Viewpoint viewpoint, ResourceSet resourceSet) {
        String viewpointID = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
        return PlatformViewpointHelper.getAFViewpoint((String)viewpointID, (ResourceSet)resourceSet);
    }

    public static org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint getAFViewpoint(Viewpoint viewpoint) {
        return AFViewpointRegistrationManager.getAFViewpoint(viewpoint, null);
    }
}

