/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.internal;

import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.domain.Activator;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraph;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraphCycle;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationStack;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.internal.VpGenerationListenerForOrchestration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.IGenerationListener;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.manager.GenerationEventManager;

public class AFViewpointGenerationOrchetrator {
    private ArchitectureFramework afDescription;
    private GenerationGraph generationGraph;
    private VpGenerationListenerForOrchestration listener;

    public AFViewpointGenerationOrchetrator(ArchitectureFramework afDescription) {
        this.afDescription = afDescription;
        this.generationGraph = new GenerationGraph(afDescription);
    }

    public int getNumberOfViewpointToGenerate() {
        if (this.generationGraph != null && this.generationGraph.getOwnedNodes().size() > 0) {
            return this.generationGraph.getOwnedNodes().size();
        }
        return -1;
    }

    public void orchestrateVPGeneration(String afModelStringURI, IProgressMonitor monitor) {
        if (!this.generationGraph.isEmpty()) {
            GenerationGraphCycle cycleDetect = new GenerationGraphCycle(this.generationGraph);
            cycleDetect.analyse();
            if (cycleDetect.exist()) {
                String message = "The next cyclic references have to be resolved \n" + cycleDetect.cyclesToString();
                Activator.getDefault().log((IStatus)new Status(4, Activator.getDefault().getPluginID(), message));
                return;
            }
            GenerationStack stack = new GenerationStack();
            stack.compute(this.generationGraph);
            Stack<Viewpoint> vpStack = stack.getViewpointStack();
            this.listener = new VpGenerationListenerForOrchestration(vpStack, this.afDescription, afModelStringURI, monitor);
            GenerationEventManager.getInstance().addGenerationListener((IGenerationListener)this.listener);
        }
    }

    public void dispose() {
        GenerationEventManager.getInstance().removeGenerationListener((IGenerationListener)this.listener);
    }
}

