/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.handlers.AbstractCompilationUnitBasedTest;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FormatterHandlerTest
extends AbstractCompilationUnitBasedTest {
    @Test
    public void testDocumentFormatting() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "package org.sample   ;\n\n      public class Baz {  String name;}\n");
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        FormattingOptions options = new FormattingOptions(4, true);
        DocumentFormattingParams params = new DocumentFormattingParams(textDocument, options);
        List edits = (List)this.server.formatting(params).get();
        Assert.assertNotNull((Object)edits);
        String expectedText = "package org.sample;\n\npublic class Baz {\n    String name;\n}\n";
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)expectedText, (Object)newText);
    }

    @Test
    public void testJavaFormatEnable() throws Exception {
        String text = "package org.sample   ;\n\n      public class Baz {  String name;}\n";
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", text);
        this.preferenceManager.getPreferences().setJavaFormatEnabled(false);
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        FormattingOptions options = new FormattingOptions(4, true);
        DocumentFormattingParams params = new DocumentFormattingParams(textDocument, options);
        List edits = (List)this.server.formatting(params).get();
        Assert.assertNotNull((Object)edits);
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)text, (Object)newText);
    }

    @Test
    public void testDocumentFormattingWithTabs() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "package org.sample;\n\npublic class Baz {\n    void foo(){\n}\n}\n");
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        FormattingOptions options = new FormattingOptions(2, false);
        DocumentFormattingParams params = new DocumentFormattingParams(textDocument, options);
        List edits = (List)this.server.formatting(params).get();
        Assert.assertNotNull((Object)edits);
        String expectedText = "package org.sample;\n\npublic class Baz {\n\tvoid foo() {\n\t}\n}\n";
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)expectedText, (Object)newText);
    }

    @Test
    public void testFormatting_onOffTags() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "package org.sample;\n\n      public class Baz {\n// @formatter:off\n\tvoid foo(){\n    }\n// @formatter:on\n}\n");
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        FormattingOptions options = new FormattingOptions(4, false);
        DocumentFormattingParams params = new DocumentFormattingParams(textDocument, options);
        List edits = (List)this.server.formatting(params).get();
        Assert.assertNotNull((Object)edits);
        String expectedText = "package org.sample;\n\npublic class Baz {\n// @formatter:off\n\tvoid foo(){\n    }\n// @formatter:on\n}\n";
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)expectedText, (Object)newText);
    }

    @Test
    public void testRangeFormatting() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "package org.sample;\n      public class Baz {\n\tvoid foo(){\n    }\n\t}\n");
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        Range range = new Range(new Position(2, 0), new Position(3, 5));
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams(range);
        params.setTextDocument(textDocument);
        params.setOptions(new FormattingOptions(3, true));
        List edits = (List)this.server.rangeFormatting(params).get();
        String expectedText = "package org.sample;\n      public class Baz {\n   void foo() {\n   }\n\t}\n";
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)expectedText, (Object)newText);
    }

    @Test
    public void testDocumentFormattingWithCustomOption() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "@Deprecated package org.sample;\n\npublic class Baz {\n    /**Java doc @param a some parameter*/\n\tvoid foo(int a){;;\n}\n}\n");
        String uri = JDTUtils.toURI((ICompilationUnit)unit);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        FormattingOptions options = new FormattingOptions(2, true);
        options.putNumber("org.eclipse.jdt.core.formatter.blank_lines_before_package", (Number)2);
        options.putString("org.eclipse.jdt.core.formatter.insert_new_line_after_annotation_on_package", "do not insert");
        options.putBoolean("org.eclipse.jdt.core.formatter.put_empty_statement_on_new_line", Boolean.TRUE);
        DocumentFormattingParams params = new DocumentFormattingParams(textDocument, options);
        List edits = (List)this.server.formatting(params).get();
        Assert.assertNotNull((Object)edits);
        String expectedText = "\n\n@Deprecated package org.sample;\n\npublic class Baz {\n  /**Java doc @param a some parameter*/\n  void foo(int a) {\n    ;\n    ;\n  }\n}\n";
        String newText = TextEditUtil.apply(unit, (Collection<? extends TextEdit>)edits);
        Assert.assertEquals((Object)expectedText, (Object)newText);
    }
}

