/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.handlers.BuildWorkspaceHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BuildWorkspaceHandlerTest
extends AbstractProjectsManagerBasedTest {
    @Mock
    private JavaClientConnection connection;
    @InjectMocks
    private BuildWorkspaceHandler handler;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.importProjects("maven/salut2");
        this.file = this.linkFilesToDefaultProject("singlefile/Single.java");
    }

    @Test
    public void testSucceedCase() throws Exception {
        BuildWorkspaceStatus result = this.handler.buildWorkspace(false, this.monitor);
        this.waitForBackgroundJobs();
        Assert.assertTrue((String)String.format("BuildWorkspaceStatus is: %s.", result.toString()), (result == BuildWorkspaceStatus.SUCCEED ? 1 : 0) != 0);
    }

    @Test
    public void testFailedCase() throws Exception {
        String codeWithError = "public class Single2 {\n\tpublic static void main(String[] args){\n\t\tint ss = 1;;\n\t}\n}";
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(codeWithError.getBytes(StandardCharsets.UTF_8));){
            this.file.setContents((InputStream)stream, true, false, this.monitor);
            this.waitForBackgroundJobs();
            BuildWorkspaceStatus result = this.handler.buildWorkspace(false, this.monitor);
            this.waitForBackgroundJobs();
            Assert.assertEquals((Object)result, (Object)BuildWorkspaceStatus.WITH_ERROR);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCanceledCase() throws Exception {
        this.monitor.setCanceled(true);
        BuildWorkspaceStatus result = this.handler.buildWorkspace(false, this.monitor);
        this.waitForBackgroundJobs();
        Assert.assertEquals((Object)result, (Object)BuildWorkspaceStatus.CANCELLED);
    }
}

