/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.correction.AbstractQuickFixTest;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.junit.Before;
import org.junit.Test;

public class JavadocQuickFixTest
extends AbstractQuickFixTest {
    private IJavaProject fJProject1;
    private IPackageFragmentRoot fSourceFolder;

    @Before
    public void setup() throws Exception {
        this.fJProject1 = this.newEmptyProject();
        Hashtable<String, String> options = TestOptions.getDefaultOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
        this.fJProject1.setOptions(options);
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src"));
    }

    @Test
    public void testMissingParam1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param b\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a \n");
        buf.append("     * @param b\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingParam2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param b \n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingParam3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param b\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param b\n");
        buf.append("     * @param c \n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int b, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingParam4() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param <A>\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param a\n");
        buf.append("     */\n");
        buf.append("    public <A, B> void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param <A>\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param <B> \n");
        buf.append("     * @param a\n");
        buf.append("     */\n");
        buf.append("    public <A, B> void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingParam5() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @param <B> Hello\n");
        buf.append(" */\n");
        buf.append("public class E<A, B> {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @param <A> \n");
        buf.append(" * @param <B> Hello\n");
        buf.append(" */\n");
        buf.append("public class E<A, B> {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingParam6() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @author ae\n");
        buf.append(" */\n");
        buf.append("public class E<A> {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @author ae\n");
        buf.append(" * @param <A> \n");
        buf.append(" */\n");
        buf.append("public class E<A> {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingReturn1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param b\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public int foo(int b, int c) {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param b\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     * @return \n");
        buf.append("     */\n");
        buf.append("    public int foo(int b, int c) {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@return' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingReturn2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     */\n");
        buf.append("    public int foo() {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @return \n");
        buf.append("     */\n");
        buf.append("    public int foo() {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@return' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    public void testMissingReturn3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @throws Exception\n");
        buf.append("     */\n");
        buf.append("    public int foo() throws Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @return \n");
        buf.append("     * @throws Exception\n");
        buf.append("     */\n");
        buf.append("    public int foo() throws Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add '@param' tag", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingThrows() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @return Returns an Int\n");
        buf.append("     */\n");
        buf.append("    public int foo() throws Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @return Returns an Int\n");
        buf.append("     * @throws Exception \n");
        buf.append("     */\n");
        buf.append("    public int foo() throws Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add '@throws' tag", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testInsertAllMissing1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @throws Exception\n");
        buf.append("     */\n");
        buf.append("    public int foo(int a, int b) throws NullPointerException, Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a \n");
        buf.append("     * @param b \n");
        buf.append("     * @return \n");
        buf.append("     * @throws NullPointerException \n");
        buf.append("     * @throws Exception\n");
        buf.append("     */\n");
        buf.append("    public int foo(int a, int b) throws NullPointerException, Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        this.assertCodeActionExists(cu, e1);
    }

    @Test
    public void testInsertAllMissing2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param b\n");
        buf.append("     * @return a number\n");
        buf.append("     */\n");
        buf.append("    public int foo(int a, int b, int c) throws NullPointerException, Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a \n");
        buf.append("     * @param b\n");
        buf.append("     * @param c \n");
        buf.append("     * @return a number\n");
        buf.append("     * @throws NullPointerException \n");
        buf.append("     * @throws Exception \n");
        buf.append("     */\n");
        buf.append("    public int foo(int a, int b, int c) throws NullPointerException, Exception {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        this.assertCodeActionExists(cu, e1);
    }

    @Test
    public void testInsertAllMissing3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E<S, T> {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @param <S> \n");
        buf.append(" * @param <T> \n");
        buf.append(" */\n");
        buf.append("public class E<S, T> {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        this.assertCodeActionExists(cu, e1);
    }

    @Test
    public void testInsertAllMissing4() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param <B> test\n");
        buf.append("     * @param b\n");
        buf.append("     * @return a number\n");
        buf.append("     */\n");
        buf.append("    public <A, B> int foo(int a, int b) throws NullPointerException {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param <A> \n");
        buf.append("     * @param <B> test\n");
        buf.append("     * @param a \n");
        buf.append("     * @param b\n");
        buf.append("     * @return a number\n");
        buf.append("     * @throws NullPointerException \n");
        buf.append("     */\n");
        buf.append("    public <A, B> int foo(int a, int b) throws NullPointerException {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add all missing tags", buf.toString());
        this.assertCodeActionExists(cu, e1);
    }

    @Test
    public void testRemoveParamTag1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveParamTag2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param a\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveThrowsTag1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     * @throws Exception Thrown by surprise.\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @param c\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a, int c) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveThrowsTag2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveThrowsTag3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     * @exception java.io.IOException\n");
        buf.append("     * @exception NullPointerException\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception java.io.IOException\n");
        buf.append("     * @exception NullPointerException\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveReturnTag1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @return Returns the result.\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws Exception {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws Exception {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testRemoveUnknownTag1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @return Returns the result.\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws Exception {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     *      comment on second line.\n");
        buf.append("     * @exception Exception\n");
        buf.append("     */\n");
        buf.append("    public void foo(int a) throws Exception {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove tag", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingMethodComment1() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    public <A> void foo(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param <A>\n");
        buf.append("     * @param a\n");
        buf.append("     * @throws IOException\n");
        buf.append("     */\n");
        buf.append("    public <A> void foo(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingMethodComment2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" *\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    public String toString() {\n");
        buf.append("        return null;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" *\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /* (non-Javadoc)\n");
        buf.append("     * @see java.lang.Object#toString()\n");
        buf.append("     */\n");
        buf.append("    public String toString() {\n");
        buf.append("        return null;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingMethodComment3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * Some comment\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    public void empty() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * Some comment\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * \n");
        buf.append("     */\n");
        buf.append("    public void empty() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingMethodComment4() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class B extends A<Integer> {\n");
        buf.append("    public void foo(Integer x) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class A<T extends Number> {\n");
        buf.append("    /**\n");
        buf.append("     * @param x\n");
        buf.append("     */\n");
        buf.append("    public void foo(T x) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("B.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package pack;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class B extends A<Integer> {\n");
        buf.append("    /* (non-Javadoc)\n");
        buf.append("     * @see pack.A#foo(java.lang.Number)\n");
        buf.append("     */\n");
        buf.append("    public void foo(Integer x) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class A<T extends Number> {\n");
        buf.append("    /**\n");
        buf.append("     * @param x\n");
        buf.append("     */\n");
        buf.append("    public void foo(T x) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingConstructorComment() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    public E(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.IOException;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     * @param a\n");
        buf.append("     * @throws IOException\n");
        buf.append("     */\n");
        buf.append("    public E(int a) throws IOException {\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingTypeComment() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E<A, B> {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @param <A>\n");
        buf.append(" * @param <B>\n");
        buf.append(" */\n");
        buf.append("public class E<A, B> {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testMissingFieldComment() throws Exception {
        Map original = this.fJProject1.getOptions(false);
        HashMap newOptions = new HashMap(original);
        this.fJProject1.setOptions(newOptions);
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    public static final int COLOR= 1;\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    public static final int COLOR= 1;\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add Javadoc comment", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testInvalidQualification1() throws Exception {
        Map original = this.fJProject1.getOptions(false);
        HashMap newOptions = new HashMap(original);
        JavaCore.setComplianceOptions((String)"1.4", newOptions);
        this.fJProject1.setOptions(newOptions);
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack;\n");
        buf.append("\n");
        buf.append("public class A {\n");
        buf.append("    public static class B {\n");
        buf.append("        public static class C {\n");
        buf.append("            \n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        pack1.createCompilationUnit("A.java", buf.toString(), false, null);
        IPackageFragment pack2 = this.fSourceFolder.createPackageFragment("pack2", false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A.B.C;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link C} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack2.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A.B.C;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link pack.A.B.C} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Qualify inner type name", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testInvalidQualification2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack;\n");
        buf.append("\n");
        buf.append("public class A {\n");
        buf.append("    public static class B {\n");
        buf.append("    }\n");
        buf.append("}\n");
        pack1.createCompilationUnit("A.java", buf.toString(), false, null);
        IPackageFragment pack2 = this.fSourceFolder.createPackageFragment("pack2", false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link A.B} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack2.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link pack.A.B} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Qualify inner type name", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testInvalidQualification3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("pack", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package pack;\n");
        buf.append("\n");
        buf.append("public class A {\n");
        buf.append("    public interface B {\n");
        buf.append("        void foo();\n");
        buf.append("    }\n");
        buf.append("}\n");
        pack1.createCompilationUnit("A.java", buf.toString(), false, null);
        IPackageFragment pack2 = this.fSourceFolder.createPackageFragment("pack2", false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link A.B#foo()} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack2.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package pack2;\n");
        buf.append("\n");
        buf.append("import pack.A;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * {@link pack.A.B#foo()} \n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Qualify inner type name", buf.toString());
        this.assertCodeActions(cu, e1);
    }
}

