/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.junit.Assert;

public class AbstractQuickFixTest
extends AbstractProjectsManagerBasedTest {
    protected void assertCodeActionExists(ICompilationUnit cu, Expected expected) throws Exception {
        List<Command> codeActionCommands = this.evaluateCodeActions(cu);
        for (Command c : codeActionCommands) {
            String actual = this.evaluateCodeActionCommand(c);
            if (!expected.content.equals(actual)) continue;
            Assert.assertEquals((Object)expected.name, (Object)c.getTitle());
            return;
        }
        String res = "";
        for (Command command : codeActionCommands) {
            if (res.length() > 0) {
                res = String.valueOf(res) + '\n';
            }
            res = String.valueOf(res) + command.getTitle();
        }
        Assert.assertEquals((String)"Not found.", (Object)expected.name, (Object)res);
    }

    protected void assertCodeActions(ICompilationUnit cu, Collection<Expected> expected) throws Exception {
        this.assertCodeActions(cu, expected.toArray(new Expected[expected.size()]));
    }

    protected void assertCodeActions(ICompilationUnit cu, Expected ... expected) throws Exception {
        List<Command> codeActionCommands = this.evaluateCodeActions(cu);
        if (codeActionCommands.size() != expected.length) {
            String res = "";
            for (Command command : codeActionCommands) {
                res = String.valueOf(res) + " '" + command.getTitle() + "'";
            }
            Assert.assertEquals((String)("Number of code actions: " + res), (long)expected.length, (long)codeActionCommands.size());
        }
        int k = 0;
        String aStr = "";
        String eStr = "";
        String testContent = "";
        for (Command c : codeActionCommands) {
            String actual = this.evaluateCodeActionCommand(c);
            Expected e = expected[k++];
            if (!e.name.equals(c.getTitle()) || !e.content.equals(actual)) {
                aStr = String.valueOf(aStr) + '\n' + c.getTitle() + '\n' + actual;
                eStr = String.valueOf(eStr) + '\n' + e.name + '\n' + e.content;
            }
            testContent = String.valueOf(testContent) + this.generateTest(actual, c.getTitle(), k);
        }
        if (aStr.length() > 0) {
            aStr = String.valueOf(aStr) + '\n' + testContent;
        }
        Assert.assertEquals((Object)eStr, (Object)aStr);
    }

    protected String generateTest(String actual, String name, int k) {
        StringBuilder builder = new StringBuilder();
        String[] lines = actual.split("\n");
        builder.append("\t\tbuf = new StringBuilder();\n");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            AbstractQuickFixTest.wrapInBufAppend(line, builder);
            ++n2;
        }
        builder.append("\t\tExpected e" + k + " = new Expected(\"" + name + "\", buf.toString());\n");
        builder.append("\n");
        return builder.toString();
    }

    private static void wrapInBufAppend(String curr, StringBuilder buf) {
        buf.append("\t\tbuf.append(\"");
        int last = curr.length() - 1;
        int k = 0;
        while (k <= last) {
            char ch = curr.charAt(k);
            if (ch == '\n') {
                buf.append("\\n\");\n");
                if (k < last) {
                    buf.append("buf.append(\"");
                }
            } else if (ch != '\r') {
                if (ch == '\t') {
                    buf.append("    ");
                } else if (ch == '\"' || ch == '\\') {
                    buf.append('\\').append(ch);
                } else {
                    buf.append(ch);
                }
            }
            ++k;
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '\n') {
            buf.append("\\n\");\n");
        }
    }

    protected Range getRange(ICompilationUnit cu, IProblem[] problems) throws JavaModelException {
        IProblem problem = problems[0];
        return JDTUtils.toRange((IOpenable)cu, (int)problem.getSourceStart(), (int)0);
    }

    protected List<Command> evaluateCodeActions(ICompilationUnit cu) throws JavaModelException {
        CompilationUnit astRoot = SharedASTProvider.getInstance().getAST((ITypeRoot)cu, null);
        IProblem[] problems = astRoot.getProblems();
        Range range = this.getRange(cu, problems);
        CodeActionParams parms = new CodeActionParams();
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        parms.setTextDocument(textDocument);
        parms.setRange(range);
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(DiagnosticsHandler.toDiagnosticsArray(Arrays.asList(problems)));
        parms.setContext(context);
        return new CodeActionHandler().getCodeActionCommands(parms, (IProgressMonitor)new NullProgressMonitor());
    }

    private String evaluateCodeActionCommand(Command c) throws BadLocationException, JavaModelException {
        Assert.assertEquals((Object)"java.apply.workspaceEdit", (Object)c.getCommand());
        Assert.assertNotNull((Object)c.getArguments());
        Assert.assertTrue((boolean)(c.getArguments().get(0) instanceof WorkspaceEdit));
        WorkspaceEdit we = (WorkspaceEdit)c.getArguments().get(0);
        Iterator editEntries = we.getChanges().entrySet().iterator();
        Map.Entry entry = editEntries.next();
        Assert.assertNotNull((String)"No edits generated", entry);
        Assert.assertEquals((String)"More than one resource modified", (Object)false, (Object)editEntries.hasNext());
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((String)((String)entry.getKey()));
        Assert.assertNotNull((String)("CU not found: " + (String)entry.getKey()), (Object)cu);
        Document doc = new Document();
        doc.set(cu.getSource());
        return TextEditUtil.apply(doc, (Collection<? extends TextEdit>)((Collection)entry.getValue()));
    }

    public class Expected {
        String name;
        String content;

        public Expected(String name, String content) {
            this.content = content;
            this.name = name;
        }
    }
}

