/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.junit.Assert;

public final class WorkspaceHelper {
    private WorkspaceHelper() {
    }

    public static void initWorkspace() throws CoreException {
        JavaLanguageServerPlugin.getProjectsManager().initializeProjects(Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)1L, (long)WorkspaceHelper.getAllProjects().size());
    }

    public static IProject getProject(String name) {
        IProject project = WorkspaceHelper.getWorkspaceRoot().getProject(name);
        return project.exists() ? project : null;
    }

    public static void deleteAllProjects() {
        WorkspaceHelper.getAllProjects().forEach(p -> WorkspaceHelper.delete(p));
    }

    public static List<IProject> getAllProjects() {
        return Arrays.asList(WorkspaceHelper.getWorkspaceRoot().getProjects());
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void delete(IProject project) {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

