/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ls.core.internal.AbstractWorkspaceTest;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.junit.Assert;
import org.junit.Test;

public class JDTUtilsTest
extends AbstractWorkspaceTest {
    @Test
    public void testGetPackageNameString() throws Exception {
        String content = "package foo.bar.internal";
        Assert.assertEquals((Object)"foo.bar.internal", (Object)JDTUtils.getPackageName(null, (String)content));
        content = "some junk";
        Assert.assertEquals((Object)"", (Object)JDTUtils.getPackageName(null, (String)content));
        content = "";
        Assert.assertEquals((Object)"", (Object)JDTUtils.getPackageName(null, (String)content));
        Assert.assertEquals((Object)"", (Object)JDTUtils.getPackageName(null, null));
    }

    @Test
    public void testGetPackageNameURI() throws Exception {
        URI src = Paths.get("projects", "eclipse", "hello", "src", "java", "Foo.java").toUri();
        String packageName = JDTUtils.getPackageName(null, (URI)src);
        Assert.assertEquals((Object)"java", (Object)packageName);
    }

    @Test
    public void testGetPackageNameNoSrc() throws Exception {
        URI uri = Paths.get("projects", "eclipse", "hello", "Foo.java").toUri();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((String)uri.toString());
        String packageName = JDTUtils.getPackageName((IJavaProject)cu.getJavaProject(), (URI)uri);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testGetPackageNameSrc() throws Exception {
        URI uri = Paths.get("projects", "eclipse", "hello", "src", "Foo.java").toUri();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((String)uri.toString());
        String packageName = JDTUtils.getPackageName((IJavaProject)cu.getJavaProject(), (URI)uri);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testResolveStandaloneCompilationUnit() throws CoreException {
        Path helloSrcRoot = Paths.get("projects", "eclipse", "hello", "src").toAbsolutePath();
        URI uri = helloSrcRoot.resolve(Paths.get("java", "Foo.java")).toUri();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((String)uri.toString());
        Assert.assertNotNull((String)("Could not find compilation unit for " + uri), (Object)cu);
        Assert.assertEquals((Object)"jdt.ls-java-project", (Object)cu.getResource().getProject().getName());
        IJavaElement[] elements = cu.getChildren();
        Assert.assertEquals((long)2L, (long)elements.length);
        Assert.assertTrue((boolean)IPackageDeclaration.class.isAssignableFrom(elements[0].getClass()));
        Assert.assertTrue((boolean)IType.class.isAssignableFrom(elements[1].getClass()));
        Assert.assertTrue((boolean)cu.getResource().isLinked());
        Assert.assertEquals((Object)cu.getResource(), (Object)JDTUtils.findResource((URI)uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0)));
        uri = helloSrcRoot.resolve("NoPackage.java").toUri();
        cu = JDTUtils.resolveCompilationUnit((String)uri.toString());
        Assert.assertNotNull((String)("Could not find compilation unit for " + uri), (Object)cu);
        Assert.assertEquals((Object)"jdt.ls-java-project", (Object)cu.getResource().getProject().getName());
        elements = cu.getChildren();
        Assert.assertEquals((long)1L, (long)elements.length);
        Assert.assertTrue((boolean)IType.class.isAssignableFrom(elements[0].getClass()));
    }

    @Test
    public void testUnresolvableCompilationUnits() throws Exception {
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit(null));
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit(null));
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit((URI)new URI("gopher://meh")));
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit((String)"foo/bar/Clazz.java"));
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit((String)"file:///foo/bar/Clazz.java"));
    }

    @Test
    public void testNonJavaCompilationUnit() throws Exception {
        Path root = Paths.get("projects", "maven", "salut").toAbsolutePath();
        URI uri = root.resolve("pom.xml").toUri();
        Assert.assertNull((Object)JDTUtils.resolveCompilationUnit((URI)uri));
        IProject project = WorkspaceHelper.getProject("jdt.ls-java-project");
        Assert.assertFalse((boolean)project.getFile("src/pom.xml").isLinked());
    }

    @Test
    public void testIgnoredUnknownSchemes() {
        PrintStream originalOut = System.out;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            System.setOut(new PrintStream(baos, true));
            System.out.flush();
            JDTUtils.resolveCompilationUnit((String)"inmemory:///foo/bar/Clazz.java");
            Assert.assertEquals((Object)"", (Object)baos.toString());
        }
        finally {
            System.setOut(originalOut);
        }
    }

    @Test
    public void testResolveStandaloneCompilationUnitWithinJob() throws Exception {
        WorkspaceJob job = new WorkspaceJob("Create link"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    JDTUtilsTest.this.testResolveStandaloneCompilationUnit();
                }
                catch (Exception e) {
                    return StatusFactory.newErrorStatus((String)"Failed to resolve CU", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)WorkspaceHelper.getProject("jdt.ls-java-project"));
        job.schedule();
        job.join(2000L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)job.getResult());
        Assert.assertNull((String)this.getStackTrace(job.getResult()), (Object)job.getResult().getException());
        Assert.assertTrue((String)job.getResult().getMessage(), (boolean)job.getResult().isOK());
    }

    private String getStackTrace(IStatus status) {
        if (status != null && status.getException() != null) {
            return Throwables.getStackTraceAsString((Throwable)status.getException());
        }
        return null;
    }

    @Test
    public void testFakeCompilationUnit() throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        File dir = new File(tempDir, "/test/src/org/eclipse");
        dir.mkdirs();
        File file = new File(dir, "Test.java");
        file.createNewFile();
        URI uri = file.toURI();
        JDTUtils.resolveCompilationUnit((URI)uri);
        IProject project = WorkspaceHelper.getProject("jdt.ls-java-project");
        IFile iFile = project.getFile("/src/org/eclipse/Test.java");
        Assert.assertTrue((String)(String.valueOf(iFile.getFullPath().toString()) + " doesn't exist."), (boolean)iFile.exists());
        Path path = Paths.get(String.valueOf(tempDir) + "/test", new String[0]);
        Files.walk(path, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }
}

