/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.IOException;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionStreamFactoryTest {
    @Test
    public void testStdIOSelection() {
        this.checkStreamProvider(ConnectionStreamFactory.StdIOStreamProvider.class);
    }

    @Test
    public void testSocketSelection() {
        System.setProperty("CLIENT_PORT", "10001");
        this.checkStreamProvider(ConnectionStreamFactory.SocketStreamProvider.class);
        System.clearProperty("CLIENT_PORT");
    }

    @Test
    public void testStdInOut() throws IOException {
        ConnectionStreamFactory tested = new ConnectionStreamFactory();
        Assert.assertSame((Object)tested.getInputStream(), (Object)JavaLanguageServerPlugin.getIn());
        Assert.assertSame((Object)tested.getOutputStream(), (Object)JavaLanguageServerPlugin.getOut());
        Assert.assertNotSame((Object)tested.getInputStream(), (Object)System.in);
        Assert.assertNotSame((Object)tested.getOutputStream(), (Object)System.out);
        System.out.println("test");
        Assert.assertTrue((tested.getInputStream().available() == 0 ? 1 : 0) != 0);
    }

    private void checkStreamProvider(Class<? extends ConnectionStreamFactory.StreamProvider> providerClass) {
        ConnectionStreamFactory tested = new ConnectionStreamFactory();
        ConnectionStreamFactory.StreamProvider provider = tested.getSelectedStream();
        Assert.assertSame(providerClass, provider.getClass());
    }
}

