/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import org.apache.commons.lang3.BooleanUtils;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DynamicRegistrationCapabilities;

public class ClientPreferences {
    private final ClientCapabilities capabilities;
    private final boolean v3supported;
    private boolean hasWorkspaceFolderCapability;

    public ClientPreferences(ClientCapabilities caps) {
        if (caps == null) {
            throw new IllegalArgumentException("ClientCapabilities can not be null");
        }
        this.capabilities = caps;
        this.v3supported = this.capabilities.getTextDocument() != null;
        this.hasWorkspaceFolderCapability = false;
    }

    public boolean isSignatureHelpSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getSignatureHelp() != null;
    }

    public boolean isWorkspaceFoldersSupported() {
        return this.hasWorkspaceFolderCapability;
    }

    public void setWorkspaceFoldersSupported(boolean capability) {
        this.hasWorkspaceFolderCapability = capability;
    }

    public boolean isCompletionSnippetsSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getCompletion().getCompletionItem().getSnippetSupport());
    }

    public boolean isV3Supported() {
        return this.v3supported;
    }

    public boolean isFormattingDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getFormatting());
    }

    public boolean isRangeFormattingDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getRangeFormatting());
    }

    public boolean isCodeLensDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCodeLens());
    }

    public boolean isSignatureHelpDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getSignatureHelp());
    }

    private boolean isDynamicRegistrationSupported(DynamicRegistrationCapabilities capability) {
        return capability != null && BooleanUtils.isTrue((Boolean)capability.getDynamicRegistration());
    }

    public boolean isRenameDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getRename());
    }

    public boolean isExecuteCommandDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getWorkspace().getExecuteCommand());
    }

    public boolean isWorkspaceSymbolDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getWorkspace().getSymbol());
    }

    public boolean isDocumentSymbolDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDocumentSymbol());
    }

    public boolean isCodeActionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCodeAction());
    }

    public boolean isDefinitionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDefinition());
    }

    public boolean isHoverDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getHover());
    }

    public boolean isReferencesDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getReferences());
    }

    public boolean isDocumentHighlightDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDocumentHighlight());
    }

    public boolean isWillSaveRegistered() {
        return this.v3supported && this.capabilities.getTextDocument().getSynchronization() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getSynchronization().getWillSave());
    }

    public boolean isWillSaveWaitUntilRegistered() {
        return this.v3supported && this.capabilities.getTextDocument().getSynchronization() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getSynchronization().getWillSaveWaitUntil());
    }
}

