/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;

public class GradleBuildSupport
implements IBuildSupport {
    public static final String GRADLE_SUFFIX = ".gradle";

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isGradleProject(project);
    }

    @Override
    public void update(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.logInfo("Starting Gradle update for " + project.getName());
        Optional build = CorePlugin.gradleWorkspaceManager().getGradleBuild(project);
        if (build.isPresent()) {
            ((GradleBuild)build.get()).synchronize(NewProjectHandler.IMPORT_AND_MERGE);
        }
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return resource != null && resource.getType() == 1 && resource.getName().endsWith(GRADLE_SUFFIX);
    }

    public static void cleanGradleModels(IProgressMonitor monitor) {
        File projectPreferences = CorePlugin.getInstance().getStateLocation().append("project-preferences").toFile();
        if (projectPreferences.isDirectory()) {
            File[] projectFiles;
            File[] fileArray = projectFiles = projectPreferences.listFiles();
            int n = projectFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File projectFile = fileArray[n2];
                String projectName = projectFile.getName();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    FileUtils.deleteRecursively((File)projectFile);
                }
                ++n2;
            }
        }
    }

    public static void saveModels() {
        CorePlugin.listenerRegistry().dispatch((Event)new WorkbenchShutdownEvent());
    }
}

