/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class WorkspaceExecuteCommandHandler {
    private static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ls.core.delegateCommandHandler";
    private static final String COMMAND = "command";
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static Set<DelegateCommandHandlerDescriptor> fgContributedCommandHandlers;

    private static synchronized Set<DelegateCommandHandlerDescriptor> getDelegateCommandHandlerDescriptors() {
        if (fgContributedCommandHandlers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            fgContributedCommandHandlers = Stream.of(elements).map(e -> new DelegateCommandHandlerDescriptor((IConfigurationElement)e)).collect(Collectors.toSet());
        }
        return fgContributedCommandHandlers;
    }

    public static Set<String> getCommands() {
        Set<DelegateCommandHandlerDescriptor> handlers = WorkspaceExecuteCommandHandler.getDelegateCommandHandlerDescriptors();
        HashSet<String> commands = new HashSet<String>();
        for (DelegateCommandHandlerDescriptor handler : handlers) {
            commands.addAll(handler.getCommands());
        }
        return commands;
    }

    public Object executeCommand(final ExecuteCommandParams params, final IProgressMonitor monitor) {
        if (params == null || params.getCommand() == null) {
            String errorMessage = "The workspace/executeCommand has empty params or command";
            JavaLanguageServerPlugin.logError(errorMessage);
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidParams, errorMessage, null));
        }
        Set<DelegateCommandHandlerDescriptor> handlers = WorkspaceExecuteCommandHandler.getDelegateCommandHandlerDescriptors();
        final Collection candidates = handlers.stream().filter(desc -> desc.getCommands().contains(params.getCommand())).collect(Collectors.toSet());
        if (candidates.size() > 1) {
            IllegalStateException ex = new IllegalStateException(String.format("Found multiple delegateCommandHandlers (%s) matching command %s", candidates, params.getCommand()));
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, ex.getMessage(), (Object)ex));
        }
        if (monitor.isCanceled()) {
            return "";
        }
        if (candidates.isEmpty()) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.MethodNotFound, String.format("No delegateCommandHandler for %s", params.getCommand()), null));
        }
        final Object[] resultValues = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                IDelegateCommandHandler delegateCommandHandler = ((DelegateCommandHandlerDescriptor)candidates.iterator().next()).getDelegateCommandHandler();
                if (delegateCommandHandler != null) {
                    resultValues[0] = delegateCommandHandler.executeCommand(params.getCommand(), params.getArguments(), monitor);
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.ls.core", 0, "Error in calling delegate command handler", ex);
                JavaLanguageServerPlugin.log((IStatus)status);
                if (ex instanceof ResponseErrorException) {
                    throw (ResponseErrorException)ex;
                }
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.UnknownErrorCode, ex.getMessage(), (Object)ex));
            }
        });
        return resultValues[0];
    }

    private static class DelegateCommandHandlerDescriptor {
        private final IConfigurationElement fConfigurationElement;
        private Set<String> fCommandIds;
        private IDelegateCommandHandler fDelegateCommandHandlerInstance;

        public DelegateCommandHandlerDescriptor(IConfigurationElement element) {
            this.fConfigurationElement = element;
            IConfigurationElement[] children = this.fConfigurationElement.getChildren(WorkspaceExecuteCommandHandler.COMMAND);
            this.fCommandIds = Stream.of(children).map(c -> c.getAttribute(WorkspaceExecuteCommandHandler.ID)).collect(Collectors.toSet());
            this.fDelegateCommandHandlerInstance = null;
        }

        public Set<String> getCommands() {
            return this.fCommandIds;
        }

        public synchronized IDelegateCommandHandler getDelegateCommandHandler() {
            block4: {
                if (this.fDelegateCommandHandlerInstance == null) {
                    try {
                        Object extension = this.fConfigurationElement.createExecutableExtension(WorkspaceExecuteCommandHandler.CLASS);
                        if (extension instanceof IDelegateCommandHandler) {
                            this.fDelegateCommandHandlerInstance = (IDelegateCommandHandler)extension;
                            break block4;
                        }
                        String message = "Invalid extension to org.eclipse.jdt.ls.core.delegateCommandHandler. Must implements org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler";
                        JavaLanguageServerPlugin.logError(message);
                        return null;
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Unable to create delegate command handler ", e);
                        return null;
                    }
                }
            }
            return this.fDelegateCommandHandlerInstance;
        }
    }
}

