/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class DocumentSymbolHandler {
    public List<? extends SymbolInformation> documentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null) {
            return Collections.emptyList();
        }
        SymbolInformation[] elements = this.getOutline(unit, monitor);
        return Arrays.asList(elements);
    }

    private SymbolInformation[] getOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>(elements.length);
            this.collectChildren(unit, elements, symbols, monitor);
            return symbols.toArray(new SymbolInformation[symbols.size()]);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem getting outline for" + unit.getElementName(), e);
            return new SymbolInformation[0];
        }
    }

    private void collectChildren(ITypeRoot unit, IJavaElement[] elements, ArrayList<SymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Location location;
            int type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element instanceof IParent) {
                this.collectChildren(unit, this.filter(((IParent)element).getChildren()), symbols, monitor);
            }
            if (((type = element.getElementType()) == 7 || type == 8 || type == 9) && (location = JDTUtils.toLocation(element)) != null) {
                SymbolInformation si = new SymbolInformation();
                String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                si.setName(name == null ? element.getElementName() : name);
                si.setKind(DocumentSymbolHandler.mapKind(element));
                if (element.getParent() != null) {
                    si.setContainerName(element.getParent().getElementName());
                }
                location.setUri(ResourceUtils.toClientUri(location.getUri()));
                si.setLocation(location);
                if (!symbols.contains(si)) {
                    symbols.add(si);
                }
            }
            ++n2;
        }
    }

    private IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !this.isInitializer((IJavaElement)e) && !this.isSyntheticElement((IJavaElement)e)).toArray(IJavaElement[]::new);
    }

    private boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static SymbolKind mapKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                return SymbolKind.Field;
            }
            case 12: 
            case 13: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: 
            case 15: {
                return SymbolKind.Variable;
            }
            case 9: {
                return SymbolKind.Method;
            }
            case 11: {
                return SymbolKind.Package;
            }
            case 7: {
                try {
                    return ((IType)element).isInterface() ? SymbolKind.Interface : SymbolKind.Class;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Class;
                }
            }
        }
        return SymbolKind.String;
    }
}

