/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;

public class CodeLensHandler {
    private static final String JAVA_SHOW_REFERENCES_COMMAND = "java.show.references";
    private static final String JAVA_SHOW_IMPLEMENTATIONS_COMMAND = "java.show.implementations";
    private static final String IMPLEMENTATION_TYPE = "implementations";
    private static final String REFERENCES_TYPE = "references";
    private final PreferenceManager preferenceManager;

    public CodeLensHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public CodeLens resolve(CodeLens lens, IProgressMonitor monitor) {
        if (lens == null) {
            return null;
        }
        List data = (List)lens.getData();
        String type = (String)data.get(2);
        Map position = (Map)data.get(1);
        String uri = (String)data.get(0);
        String label = null;
        String command = null;
        List<Object> locations = null;
        if (REFERENCES_TYPE.equals(type)) {
            label = "reference";
            command = JAVA_SHOW_REFERENCES_COMMAND;
        } else if (IMPLEMENTATION_TYPE.equals(type)) {
            label = "implementation";
            command = JAVA_SHOW_IMPLEMENTATIONS_COMMAND;
        }
        try {
            ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
            if (typeRoot != null) {
                IJavaElement element = JDTUtils.findElementAtSelection(typeRoot, ((Double)position.get("line")).intValue(), ((Double)position.get("character")).intValue(), this.preferenceManager, monitor);
                if (REFERENCES_TYPE.equals(type)) {
                    try {
                        locations = this.findReferences(element, monitor);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                } else if (IMPLEMENTATION_TYPE.equals(type) && element instanceof IType) {
                    try {
                        locations = this.findImplementations((IType)element, monitor);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem resolving code lens", e);
        }
        if (locations == null) {
            locations = Collections.emptyList();
        }
        if (label != null && command != null) {
            int size = locations.size();
            Command c = new Command(String.valueOf(size) + " " + label + (size == 1 ? "" : "s"), command, Arrays.asList(uri, position, locations));
            lens.setCommand(c);
        }
        return lens;
    }

    private List<Location> findImplementations(IType type, IProgressMonitor monitor) throws JavaModelException {
        IType[] results = type.newTypeHierarchy(monitor).getAllSubtypes(type);
        ArrayList<Location> result = new ArrayList<Location>();
        IType[] iTypeArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            ICompilationUnit compilationUnit = (ICompilationUnit)t.getAncestor(5);
            if (compilationUnit != null) {
                Location location = JDTUtils.toLocation((IJavaElement)t);
                result.add(location);
            }
            ++n2;
        }
        return result;
    }

    private List<Location> findReferences(IJavaElement element, IProgressMonitor monitor) throws JavaModelException, CoreException {
        if (element == null) {
            return Collections.emptyList();
        }
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)2);
        final ArrayList<Location> result = new ArrayList<Location>();
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    if (compilationUnit == null) {
                        return;
                    }
                    Location location = JDTUtils.toLocation(compilationUnit, match.getOffset(), match.getLength());
                    result.add(location);
                }
            }
        }, monitor);
        return result;
    }

    public List<CodeLens> getCodeLensSymbols(String uri, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isCodeLensEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = JDTUtils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            ICompilationUnit typeRoot = unit != null ? unit : classFile;
            IJavaElement[] elements = typeRoot.getChildren();
            ArrayList<CodeLens> lenses = new ArrayList<CodeLens>(elements.length);
            this.collectCodeLenses((ITypeRoot)typeRoot, elements, lenses, monitor);
            if (monitor.isCanceled()) {
                lenses.clear();
            }
            return lenses;
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem getting code lenses for" + unit.getElementName(), e);
            return Collections.emptyList();
        }
    }

    private void collectCodeLenses(ITypeRoot typeRoot, IJavaElement[] elements, ArrayList<CodeLens> lenses, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IType type;
                IJavaElement element;
                block8: {
                    block7: {
                        element = iJavaElementArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (element.getElementType() != 7) break block7;
                        this.collectCodeLenses(typeRoot, ((IType)element).getChildren(), lenses, monitor);
                        break block8;
                    }
                    if (element.getElementType() != 9 || JDTUtils.isHiddenGeneratedElement(element)) break block9;
                }
                if (this.preferenceManager.getPreferences().isReferencesCodeLensEnabled()) {
                    CodeLens lens = this.getCodeLens(REFERENCES_TYPE, element, typeRoot);
                    lenses.add(lens);
                }
                if (this.preferenceManager.getPreferences().isImplementationsCodeLensEnabled() && element instanceof IType && ((type = (IType)element).isInterface() || Flags.isAbstract((int)type.getFlags()))) {
                    CodeLens lens = this.getCodeLens(IMPLEMENTATION_TYPE, element, typeRoot);
                    lenses.add(lens);
                }
            }
            ++n2;
        }
    }

    private CodeLens getCodeLens(String type, IJavaElement element, ITypeRoot typeRoot) throws JavaModelException {
        CodeLens lens = new CodeLens();
        ISourceRange r = ((ISourceReference)element).getNameRange();
        Range range = JDTUtils.toRange((IOpenable)typeRoot, r.getOffset(), r.getLength());
        lens.setRange(range);
        String uri = ResourceUtils.toClientUri(JDTUtils.toUri(typeRoot));
        lens.setData(Arrays.asList(uri, range.getStart(), type));
        return lens;
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)1);
    }
}

