/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.ls.core.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;

public class NewVariableCorrectionProposal
extends ASTRewriteCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    public static final int CONST_FIELD = 4;
    public static final int ENUM_CONST = 5;
    private final int fVariableKind;
    private final SimpleName fOriginalNode;
    private final ITypeBinding fSenderBinding;

    public NewVariableCorrectionProposal(String label, ICompilationUnit cu, int variableKind, SimpleName node, ITypeBinding senderBinding, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        if (senderBinding == null) {
            Assert.isTrue((variableKind == 3 || variableKind == 1 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)Bindings.isDeclarationBinding((IBinding)senderBinding));
        }
        this.fVariableKind = variableKind;
        this.fOriginalNode = node;
        this.fSenderBinding = senderBinding;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit cu = ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        switch (this.fVariableKind) {
            case 3: {
                return this.doAddParam(cu);
            }
            case 2: 
            case 4: {
                return this.doAddField(cu);
            }
            case 1: {
                return this.doAddLocal(cu);
            }
            case 5: {
                return this.doAddEnumConst(cu);
            }
        }
        throw new IllegalArgumentException("Unsupported variable kind: " + this.fVariableKind);
    }

    private ASTRewrite doAddParam(CompilationUnit cu) {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
            newDecl.setType(this.evaluateVariableType(ast, imports, importRewriteContext, (IBinding)methodDeclaration.resolveBinding(), ImportRewrite.TypeLocation.PARAMETER));
            newDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.PARAMETERS_PROPERTY);
            listRewriter.insertLast((ASTNode)newDecl, null);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null) {
                HashSet<String> leadingNames = new HashSet<String>();
                for (SingleVariableDeclaration curr : methodDeclaration.parameters()) {
                    leadingNames.add(curr.getName().getIdentifier());
                }
                SimpleName newTagRef = ast.newSimpleName(node.getIdentifier());
                TagElement newTagElement = ast.newTagElement();
                newTagElement.setTagName("@param");
                newTagElement.fragments().add(newTagRef);
                TextElement commentStart = ast.newTextElement();
                newTagElement.fragments().add(commentStart);
                ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTagElement, leadingNames);
            }
            return rewrite;
        }
        return null;
    }

    private boolean isAssigned(Statement statement, SimpleName name) {
        ExpressionStatement exstat;
        if (statement instanceof ExpressionStatement && (exstat = (ExpressionStatement)statement).getExpression() instanceof Assignment) {
            Assignment assignment = (Assignment)exstat.getExpression();
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private boolean isForStatementInit(Statement statement, SimpleName name) {
        ForStatement forStatement;
        List list;
        if (statement instanceof ForStatement && (list = (forStatement = (ForStatement)statement).initializers()).size() == 1 && list.get(0) instanceof Assignment) {
            Assignment assignment = (Assignment)list.get(0);
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private boolean isEnhancedForStatementVariable(Statement statement, SimpleName name) {
        if (statement instanceof EnhancedForStatement) {
            EnhancedForStatement forStatement = (EnhancedForStatement)statement;
            SingleVariableDeclaration param = forStatement.getParameter();
            return param.getType() == name.getParent();
        }
        return false;
    }

    private ASTRewrite doAddLocal(CompilationUnit cu) {
        Block body;
        AST ast = cu.getAST();
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)this.fOriginalNode);
        IMethodBinding targetContext = null;
        if (decl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)decl).getBody();
            targetContext = ((MethodDeclaration)decl).resolveBinding();
        } else if (decl instanceof Initializer) {
            body = ((Initializer)decl).getBody();
            targetContext = Bindings.getBindingOfParentType((ASTNode)decl);
        } else {
            return null;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
        SimpleName[] names = this.getAllReferences(body);
        ASTNode dominant = this.getDominantNode(names);
        Statement dominantStatement = ASTResolving.findParentStatement((ASTNode)dominant);
        if (ASTNodes.isControlStatementBody(dominantStatement.getLocationInParent())) {
            dominantStatement = (Statement)dominantStatement.getParent();
        }
        SimpleName node = names[0];
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)node, imports);
        if (this.isAssigned(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression newDecl = ast.newVariableDeclarationExpression(newDeclFrag);
            newDecl.setType(this.evaluateVariableType(ast, imports, importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            newDeclFrag.setInitializer(placeholder);
            newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.replace((ASTNode)assignment, (ASTNode)newDecl, null);
            return rewrite;
        }
        if (dominant != dominantStatement && this.isForStatementInit(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression expression = ast.newVariableDeclarationExpression(frag);
            frag.setName(ast.newSimpleName(node.getIdentifier()));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            frag.setInitializer(placeholder);
            expression.setType(this.evaluateVariableType(ast, imports, importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
            rewrite.replace((ASTNode)assignment, (ASTNode)expression, null);
            return rewrite;
        }
        if (dominant != dominantStatement && this.isEnhancedForStatementVariable(dominantStatement, node)) {
            EnhancedForStatement enhancedForStatement = (EnhancedForStatement)dominantStatement;
            SingleVariableDeclaration parameter = enhancedForStatement.getParameter();
            Expression expression = enhancedForStatement.getExpression();
            SimpleName newName = (SimpleName)rewrite.createMoveTarget((ASTNode)node);
            rewrite.set((ASTNode)parameter, (StructuralPropertyDescriptor)SingleVariableDeclaration.NAME_PROPERTY, (Object)newName, null);
            ITypeBinding elementBinding = null;
            ITypeBinding typeBinding = expression.resolveTypeBinding();
            if (typeBinding != null) {
                if (typeBinding.isArray()) {
                    elementBinding = typeBinding.getElementType();
                } else {
                    ITypeBinding[] typeArguments;
                    ITypeBinding iterable = Bindings.findTypeInHierarchy(typeBinding, "java.lang.Iterable");
                    if (iterable != null && (typeArguments = iterable.getTypeArguments()).length == 1) {
                        elementBinding = typeArguments[0];
                        elementBinding = Bindings.normalizeForDeclarationUse(elementBinding, ast);
                    }
                }
            }
            Object type = elementBinding != null ? imports.addImport(elementBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE) : ast.newSimpleType((Name)ast.newSimpleName("Object"));
            rewrite.set((ASTNode)parameter, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, type, null);
            return rewrite;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
        newDecl.setType(this.evaluateVariableType(ast, imports, importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
        Statement statement = dominantStatement;
        List<? extends ASTNode> list = ASTNodes.getContainingList((ASTNode)statement);
        while (list == null && statement.getParent() instanceof Statement) {
            statement = (Statement)statement.getParent();
            list = ASTNodes.getContainingList((ASTNode)statement);
        }
        if (list != null) {
            ASTNode parent = statement.getParent();
            StructuralPropertyDescriptor childProperty = statement.getLocationInParent();
            if (childProperty.isChildListProperty()) {
                rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)childProperty).insertBefore((ASTNode)newDecl, (ASTNode)statement, null);
                return rewrite;
            }
            return null;
        }
        return rewrite;
    }

    private SimpleName[] getAllReferences(Block body) {
        SimpleName[] names = LinkedNodeFinder.findByProblems((ASTNode)body, this.fOriginalNode);
        if (names == null) {
            return new SimpleName[]{this.fOriginalNode};
        }
        if (names.length > 1) {
            Arrays.sort(names, new Comparator<SimpleName>(){

                @Override
                public int compare(SimpleName s1, SimpleName s2) {
                    return s1.getStartPosition() - s2.getStartPosition();
                }
            });
        }
        return names;
    }

    private ASTNode getDominantNode(SimpleName[] names) {
        SimpleName dominator = names[0];
        int i = 1;
        while (i < names.length) {
            SimpleName curr = names[i];
            if (curr != dominator) {
                ASTNode parent = this.getCommonParent((ASTNode)curr, (ASTNode)dominator);
                if (curr.getStartPosition() < dominator.getStartPosition()) {
                    dominator = curr;
                }
                while (dominator.getParent() != parent) {
                    dominator = dominator.getParent();
                }
            }
            ++i;
        }
        int parentKind = dominator.getParent().getNodeType();
        if (parentKind != 8 && parentKind != 24) {
            return dominator.getParent();
        }
        return dominator;
    }

    private ASTNode getCommonParent(ASTNode node1, ASTNode node2) {
        ASTNode parent = node1.getParent();
        while (parent != null && !ASTNodes.isParent(node2, parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private ASTRewrite doAddField(CompilationUnit astRoot) {
        SimpleName node = this.fOriginalNode;
        boolean isInDifferentCU = false;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
            isInDifferentCU = true;
        }
        ImportRewrite imports = this.createImportRewrite(astRoot);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)ASTResolving.findParentBodyDeclaration((ASTNode)node), imports);
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(node.getIdentifier()));
            Type type = this.evaluateVariableType(ast, imports, importRewriteContext, (IBinding)this.fSenderBinding, ImportRewrite.TypeLocation.FIELD);
            FieldDeclaration newDecl = ast.newFieldDeclaration(fragment);
            newDecl.setType(type);
            newDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.evaluateFieldModifiers(newTypeDecl)));
            if (this.fSenderBinding.isInterface() || this.fVariableKind == 4) {
                fragment.setInitializer(ASTNodeFactory.newDefaultExpression(ast, type, 0));
            }
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List<BodyDeclaration> decls = ASTNodes.getChildListProperty(newTypeDecl, property);
            int maxOffset = isInDifferentCU ? -1 : node.getStartPosition();
            int insertIndex = this.findFieldInsertIndex(decls, newDecl, maxOffset);
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt((ASTNode)newDecl, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private int findFieldInsertIndex(List<BodyDeclaration> decls, FieldDeclaration newDecl, int maxOffset) {
        if (maxOffset != -1) {
            int i = decls.size() - 1;
            while (i >= 0) {
                BodyDeclaration curr = decls.get(i);
                if (maxOffset > curr.getStartPosition() + curr.getLength()) {
                    return BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newDecl, decls.subList(0, i + 1));
                }
                --i;
            }
            return 0;
        }
        return BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newDecl, decls);
    }

    private Type evaluateVariableType(AST ast, ImportRewrite imports, ImportRewrite.ImportRewriteContext importRewriteContext, IBinding targetContext, ImportRewrite.TypeLocation location) {
        ITypeBinding[] bindings;
        MethodInvocation parent;
        if (this.fOriginalNode.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)this.fOriginalNode.getParent()).getExpression() == this.fOriginalNode && (bindings = ASTResolving.getQualifierGuess((ASTNode)this.fOriginalNode.getRoot(), (String)parent.getName().getIdentifier(), (List)parent.arguments(), (IBinding)targetContext)).length > 0) {
            return imports.addImport(bindings[0], ast, importRewriteContext, location);
        }
        ITypeBinding binding = ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode);
        if (binding != null) {
            if (binding.isWildcardType() && (binding = ASTResolving.normalizeWildcardType((ITypeBinding)binding, (boolean)this.isVariableAssigned(), (AST)ast)) == null) {
                binding = ast.resolveWellKnownType("java.lang.Object");
            }
            return imports.addImport(binding, ast, importRewriteContext, location);
        }
        Type type = ASTResolving.guessTypeForReference(ast, (ASTNode)this.fOriginalNode);
        if (type != null) {
            return type;
        }
        if (this.fVariableKind == 4) {
            return ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private boolean isVariableAssigned() {
        ASTNode parent = this.fOriginalNode.getParent();
        return parent instanceof Assignment && this.fOriginalNode == ((Assignment)parent).getLeftHandSide();
    }

    private int evaluateFieldModifiers(ASTNode newTypeDecl) {
        if (this.fSenderBinding.isAnnotation()) {
            return 0;
        }
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDecls = ((TypeDeclaration)newTypeDecl).getFields();
            if (fieldDecls.length > 0) {
                return fieldDecls[0].getModifiers();
            }
            return 0;
        }
        int modifiers = 0;
        if (this.fVariableKind == 4) {
            modifiers |= 0x18;
        } else {
            ASTNode parent = this.fOriginalNode.getParent();
            if (parent instanceof QualifiedName) {
                IBinding qualifierBinding = ((QualifiedName)parent).getQualifier().resolveBinding();
                if (qualifierBinding instanceof ITypeBinding) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                modifiers |= 8;
            }
        }
        ASTNode node = ASTResolving.findParentType((ASTNode)this.fOriginalNode, (boolean)true);
        modifiers = newTypeDecl.equals((Object)node) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration ? (modifiers |= 4) : (modifiers |= 1));
        return modifiers;
    }

    private ASTRewrite doAddEnumConst(CompilationUnit astRoot) {
        SimpleName node = this.fOriginalNode;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            EnumConstantDeclaration constDecl = ast.newEnumConstantDeclaration();
            constDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            listRewriter.insertLast((ASTNode)constDecl, null);
            return rewrite;
        }
        return null;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

