/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance) {
        super(name, cu, relevance);
        this.fRewrite = rewrite;
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public ImportRewrite createImportRewrite(CompilationUnit astRoot) {
        this.fImportRewrite = StubUtility.createImportRewrite(astRoot, true);
        return this.fImportRewrite;
    }

    @Override
    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST();
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(StatusFactory.newErrorStatus("Invalid AST rewriter", e));
            }
        }
        if (this.fImportRewrite != null) {
            editRoot.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = StatusFactory.newErrorStatus("Rewrite not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

