/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.ls.core.internal.corext.util.JavaConventionsUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Resources;

public class Checks {
    private Checks() {
    }

    public static RefactoringStatus checkIdentifier(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateIdentifier(name, context));
    }

    public static RefactoringStatus checkMethodName(String name, IJavaElement context) {
        RefactoringStatus status = Checks.checkName(name, JavaConventionsUtil.validateMethodName(name, context));
        if (status.isOK() && !Checks.startsWithLowerCase(name)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return status;
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = org.eclipse.jdt.internal.corext.dom.Bindings.findMethodInType((ITypeBinding)type, (String)methodName, (ITypeBinding[])parameters);
        if (method != null) {
            if (method.isConstructor()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.Checks_methodName_constructor, new Object[]{BasicElementLabels.getJavaElementName((String)type.getName())}));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_exists, new Object[]{BasicElementLabels.getJavaElementName((String)methodName), BasicElementLabels.getJavaElementName((String)type.getName())}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{BasicElementLabels.getJavaElementName((String)methodName), BasicElementLabels.getJavaElementName((String)dc.getName())}), JavaStatusContext.create(method));
            } else if (method.isConstructor()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.Checks_methodName_constructor, new Object[]{BasicElementLabels.getJavaElementName((String)dc.getName())}));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{BasicElementLabels.getJavaElementName((String)methodName), BasicElementLabels.getJavaElementName((String)dc.getName())}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, (Object)context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }
}

