/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.GetterSetterCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class CompletionProposalRequestor
extends CompletionRequestor {
    private List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    private final ICompilationUnit unit;
    private CompletionProposalDescriptionProvider descriptionProvider;
    private CompletionResponse response;
    private boolean fIsTestCodeExcluded;

    public CompletionProposalRequestor(ICompilationUnit aUnit, int offset) {
        this.unit = aUnit;
        this.response = new CompletionResponse();
        this.response.setOffset(offset);
        this.fIsTestCodeExcluded = !this.isTestSource(this.unit.getJavaProject(), this.unit);
        this.setRequireExtendedContext(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTestSource(IJavaProject project, ICompilationUnit cu) {
        if (project == null) {
            return true;
        }
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public void accept(CompletionProposal proposal) {
        if (!this.isIgnored(proposal.getKind())) {
            if (proposal.getKind() == 11) {
                this.acceptPotentialMethodDeclaration(proposal);
            } else {
                if (proposal.getKind() == 8 && this.unit.getParent() != null && String.valueOf(proposal.getCompletion()).equals(this.unit.getParent().getElementName())) {
                    proposal.setRelevance(proposal.getRelevance() + 1);
                }
                this.proposals.add(proposal);
            }
        }
    }

    public List<CompletionItem> getCompletionItems() {
        this.response.setProposals(this.proposals);
        CompletionResponses.store(this.response);
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(this.proposals.size());
        int i = 0;
        while (i < this.proposals.size()) {
            completionItems.add(this.toCompletionItem(this.proposals.get(i), i));
            ++i;
        }
        return completionItems;
    }

    public CompletionItem toCompletionItem(CompletionProposal proposal, int index) {
        CompletionItem $ = new CompletionItem();
        $.setKind(this.mapKind(proposal.getKind()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uri", this.unit.getResource().getLocationURI().toString());
        data.put("rid", String.valueOf(this.response.getId()));
        data.put("pid", String.valueOf(index));
        $.setData(data);
        this.descriptionProvider.updateDescription(proposal, $);
        $.setSortText(SortTextHelper.computeSortText(proposal));
        return $;
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.response.setContext(context);
        this.descriptionProvider = new CompletionProposalDescriptionProvider(context);
    }

    private CompletionItemKind mapKind(int kind) {
        switch (kind) {
            case 26: 
            case 27: {
                return CompletionItemKind.Constructor;
            }
            case 1: 
            case 9: {
                return CompletionItemKind.Class;
            }
            case 8: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                return CompletionItemKind.Module;
            }
            case 2: 
            case 25: {
                return CompletionItemKind.Field;
            }
            case 3: {
                return CompletionItemKind.Keyword;
            }
            case 4: {
                return CompletionItemKind.Reference;
            }
            case 5: 
            case 10: {
                return CompletionItemKind.Variable;
            }
            case 6: 
            case 7: 
            case 11: 
            case 24: {
                return CompletionItemKind.Function;
            }
        }
        return CompletionItemKind.Text;
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        super.setIgnored(completionProposalKind, ignore);
        if (completionProposalKind == 7 && !ignore) {
            this.setRequireExtendedContext(true);
        }
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        try {
            IJavaElement enclosingElement = null;
            if (this.response.getContext().isExtended()) {
                enclosingElement = this.response.getContext().getEnclosingElement();
            } else if (this.unit != null) {
                enclosingElement = this.unit.getElementAt(proposal.getCompletionLocation() + 1);
            }
            if (enclosingElement == null) {
                return;
            }
            IType type = (IType)enclosingElement.getAncestor(7);
            if (type != null) {
                String prefix = String.valueOf(proposal.getName());
                int completionStart = proposal.getReplaceStart();
                int completionEnd = proposal.getReplaceEnd();
                int relevance = proposal.getRelevance() + 6;
                GetterSetterCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance, this.proposals);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Accept potential method declaration failed for completion ", e);
        }
    }

    public boolean isTestCodeExcluded() {
        return this.fIsTestCodeExcluded;
    }
}

