/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public final class SharedASTProvider {
    private static SharedASTProvider instance = new SharedASTProvider();
    private ConcurrentMap<String, CompilationUnit> cache = new ConcurrentHashMap<String, CompilationUnit>();
    private int astCreationCount = 0;

    private SharedASTProvider() {
    }

    public void dispose() {
        this.invalidateAll();
    }

    public static SharedASTProvider getInstance() {
        return instance;
    }

    public CompilationUnit getAST(ITypeRoot input, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        if (!this.shouldCache(input)) {
            JavaLanguageServerPlugin.logInfo("Creating uncached AST for " + input.getPath().toString());
            return SharedASTProvider.createAST(input, progressMonitor);
        }
        String identifier = input.getHandleIdentifier();
        return this.cache.computeIfAbsent(identifier, k -> {
            JavaLanguageServerPlugin.logInfo("Caching AST for " + input.getPath().toString());
            CompilationUnit astRoot = SharedASTProvider.createAST(input, progressMonitor);
            ++this.astCreationCount;
            return astRoot;
        });
    }

    public List<CompilationUnit> getASTs(List<ICompilationUnit> inputs, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled() || inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CompilationUnit> result = new ArrayList<CompilationUnit>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)inputs.size());
        for (ICompilationUnit input : inputs) {
            result.add(this.getAST((ITypeRoot)input, (IProgressMonitor)subMonitor.split(1)));
        }
        return result;
    }

    public void setAST(CompilationUnit astRoot) {
        ITypeRoot typeRoot = astRoot.getTypeRoot();
        if (this.shouldCache(typeRoot)) {
            this.cache.put(typeRoot.getHandleIdentifier(), astRoot);
        }
    }

    private boolean shouldCache(ITypeRoot input) {
        if (input.getElementType() != 5) {
            return false;
        }
        ICompilationUnit cu = (ICompilationUnit)input;
        return cu.getOwner() == null && cu.isWorkingCopy();
    }

    public void invalidate(ITypeRoot root) {
        CompilationUnit removed;
        if (root != null && (removed = (CompilationUnit)this.cache.remove(root.getHandleIdentifier())) != null) {
            JavaLanguageServerPlugin.logInfo("Releasing AST for " + root.getPath().toString());
        }
    }

    public void invalidateAll() {
        this.cache.clear();
        JavaLanguageServerPlugin.logInfo("Releasing all ASTs");
    }

    private static CompilationUnit createAST(final ITypeRoot input, final IProgressMonitor progressMonitor) {
        if (!SharedASTProvider.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] root = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    ASTParser parser = SharedASTProvider.newASTParser();
                    parser.setSource(input);
                    root[0] = (CompilationUnit)parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], (int)4);
                }
                catch (OperationCanceledException ex) {
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.ls.core", 0, "Error in JDT Core during AST creation", ex);
                JavaLanguageServerPlugin.log((IStatus)status);
            }
        });
        return root[0];
    }

    public static ASTParser newASTParser() {
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        return parser;
    }

    private static boolean hasSource(ITypeRoot je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je.getBuffer() != null;
        }
        catch (JavaModelException ex) {
            Status status = new Status(4, "org.eclipse.jdt.ls.core", 0, "Error in JDT Core during AST creation", (Throwable)ex);
            JavaLanguageServerPlugin.log((IStatus)status);
            return false;
        }
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public int getASTCreationCount() {
        return this.astCreationCount;
    }

    public void clearASTCreationCount() {
        this.astCreationCount = 0;
    }
}

