/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.SliceNDIterator;
import org.eclipse.january.metadata.Dirtiable;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.eclipse.january.metadata.internal.Axes;
import org.eclipse.january.metadata.internal.NullStorelessUnivariateStatistic;

public class StatisticsMetadataImpl<T>
implements StatisticsMetadata<T> {
    private static final long serialVersionUID = -6660224998596148031L;
    private static final int COMBOS = 4;
    private int hash;
    private Class<? extends Dataset> clazz;
    private int isize;
    private boolean isFloat;
    private transient Dataset dataset;
    private Map<Axes, Dataset[][]> axisStats = null;
    private MaxMin<T>[] mms;
    private SummaryStatistics[][] summaries;
    @Dirtiable
    private boolean isDirty = true;
    private static final int AS_MAX = 0;
    private static final int AS_MIN = 1;
    private static final int AS_MAX_INDEX = 2;
    private static final int AS_MIN_INDEX = 3;
    private static final int AS_CNT = 4;
    private static final int AS_MEAN = 5;
    private static final int AS_SUM = 6;
    private static final int AS_VAR = 7;

    public StatisticsMetadataImpl() {
    }

    private StatisticsMetadataImpl(StatisticsMetadataImpl<T> statsMetadata) {
        int i;
        this.hash = statsMetadata.hash;
        this.isize = statsMetadata.isize;
        this.clazz = statsMetadata.clazz;
        this.isFloat = statsMetadata.isFloat;
        this.dataset = statsMetadata.dataset.getView(false);
        this.axisStats = new HashMap<Axes, Dataset[][]>(statsMetadata.axisStats);
        if (statsMetadata.mms != null) {
            this.mms = new MaxMin[4];
            i = 0;
            while (i < this.mms.length) {
                this.mms[i] = statsMetadata.mms[i];
                ++i;
            }
        }
        this.summaries = new SummaryStatistics[4][];
        i = 0;
        while (i < this.summaries.length) {
            SummaryStatistics[] oSummary = statsMetadata.summaries[i];
            if (oSummary != null) {
                SummaryStatistics[] nSummary = new SummaryStatistics[this.isize];
                this.summaries[i] = nSummary;
                int j = 0;
                while (j < this.isize) {
                    nSummary[j] = oSummary[j];
                    ++j;
                }
            }
            ++i;
        }
        this.isDirty = statsMetadata.isDirty;
    }

    @Override
    public void initialize(Dataset dataset) {
        this.dataset = dataset.getView(false);
        this.dataset.clearMetadata(null);
        this.isFloat = dataset.hasFloatingPointElements();
        this.clazz = InterfaceUtils.getLargestInterface(dataset);
        this.isize = dataset.getElementsPerItem();
        this.mms = new MaxMin[4];
        this.summaries = new SummaryStatistics[4][];
        this.axisStats = new HashMap<Axes, Dataset[][]>();
        this.setDirty();
    }

    private int refresh(boolean maxMin, boolean ... ignoreInvalids) {
        int idx;
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (this.isDirty) {
            this.clearAll();
        }
        if (this.isFloat) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if (this.mms[idx = (ignoreNaNs ? 1 : 0) * 2 + (ignoreInfs ? 1 : 0)] == null) {
            this.mms[idx] = new MaxMin();
        }
        if (maxMin) {
            if (this.mms[idx].maximum == null) {
                this.setMaxMinSum(this.mms[idx], ignoreNaNs, ignoreInfs);
            }
        } else if (this.summaries[idx] == null) {
            this.summaries[idx] = this.createSummaryStats(this.mms[idx], ignoreNaNs, ignoreInfs);
        }
        this.isDirty = false;
        return idx;
    }

    /*
     * Unable to fully structure code
     */
    private void setMaxMinSum(MaxMin<T> mm, boolean ignoreNaNs, boolean ignoreInfs) {
        block16: {
            block15: {
                block14: {
                    iter = this.dataset.getIterator();
                    if (!InterfaceUtils.isNumerical(this.clazz)) {
                        smin = smax = this.dataset.getStringAbs(0);
                        while (iter.hasNext()) {
                            val = this.dataset.getStringAbs(iter.index);
                            this.hash = this.hash * 19 + val.hashCode();
                            if (val.compareTo(smax) > 0) {
                                smax = val;
                            }
                            if (val.compareTo(smin) >= 0) continue;
                            smin = val;
                        }
                        this.hash = this.hash * 19 + this.clazz.hashCode() * 17 + this.isize;
                        mm.maximum = smax;
                        mm.minimum = smin;
                        mm.sum = null;
                        mm.maximumPositions = null;
                        mm.minimumPositions = null;
                        return;
                    }
                    if (this.isize != 1) ** GOTO lbl74
                    amax = -Infinity;
                    amin = Infinity;
                    asum = 0.0;
                    hasNaNs = false;
                    if (!this.isFloat || !ignoreNaNs && !ignoreInfs) break block14;
                    while (iter.hasNext()) {
                        val = this.dataset.getElementDoubleAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                        if (Double.isNaN(val)) {
                            if (ignoreNaNs) continue;
                            hasNaNs = true;
                        } else if (Double.isInfinite(val) && ignoreInfs) continue;
                        asum += val;
                        if (val > amax) {
                            amax = val;
                        }
                        if (!(val < amin)) continue;
                        amin = val;
                    }
                    break block15;
                }
                if (!this.isFloat) ** GOTO lbl62
                while (iter.hasNext()) {
                    val = this.dataset.getElementDoubleAbs(iter.index);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    if (Double.isNaN(val)) {
                        hasNaNs = true;
                        continue;
                    }
                    asum += val;
                    if (val > amax) {
                        amax = val;
                    }
                    if (!(val < amin)) continue;
                    amin = val;
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    val = this.dataset.getElementLongAbs(iter.index);
                    this.hash = (int)((long)(this.hash * 19) + val);
                    asum += (double)val;
                    if ((double)val > amax) {
                        amax = val;
                    }
                    if (!((double)val < amin)) continue;
                    amin = val;
lbl62:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            mm.maximum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, amax);
            mm.minimum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, amin);
            mm.sum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, asum);
            break block16;
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < this.isize) {
                    val = this.dataset.getElementDoubleAbs(iter.index + j);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    ++j;
                }
lbl74:
                // 2 sources

                ** while (iter.hasNext())
            }
lbl75:
            // 1 sources

            mm.maximum = null;
            mm.minimum = null;
            mm.sum = null;
        }
        this.hash = this.hash * 19 + this.clazz.hashCode() * 17 + this.isize;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
    }

    /*
     * Unable to fully structure code
     */
    private SummaryStatistics[] createSummaryStats(MaxMin<T> mm, boolean ignoreNaNs, boolean ignoreInfs) {
        block16: {
            block13: {
                block15: {
                    block14: {
                        iter = this.dataset.getIterator();
                        istats = new SummaryStatistics[this.isize];
                        i = 0;
                        while (i < this.isize) {
                            istats[i] = new SummaryStatistics();
                            istats[i].setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
                            ++i;
                        }
                        if (this.isize != 1) break block13;
                        hasNaNs = false;
                        stats = istats[0];
                        if (!this.isFloat || !ignoreNaNs && !ignoreInfs) break block14;
                        while (iter.hasNext()) {
                            val = this.dataset.getElementDoubleAbs(iter.index);
                            this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                            if (Double.isNaN(val)) {
                                if (ignoreNaNs) continue;
                                hasNaNs = true;
                            } else if (Double.isInfinite(val) && ignoreInfs) continue;
                            stats.addValue(val);
                        }
                        break block15;
                    }
                    if (!this.isFloat) ** GOTO lbl37
                    while (iter.hasNext()) {
                        val = this.dataset.getElementDoubleAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                        if (Double.isNaN(val)) {
                            hasNaNs = true;
                        }
                        stats.addValue(val);
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        val = this.dataset.getElementLongAbs(iter.index);
                        this.hash = (int)((long)(this.hash * 19) + val);
                        stats.addValue((double)val);
lbl37:
                        // 2 sources

                        ** while (iter.hasNext())
                    }
                }
                mm.maximum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, stats.getMax());
                mm.minimum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, stats.getMin());
                mm.sum = hasNaNs != false ? Double.valueOf(NaN) : InterfaceUtils.fromDoubleToBiggestNumber(this.clazz, stats.getSum());
                break block16;
            }
            vals = new double[this.isize];
            while (iter.hasNext()) {
                okay = true;
                j = 0;
                while (j < this.isize) {
                    val = this.dataset.getElementDoubleAbs(iter.index + j);
                    if (ignoreNaNs && Double.isNaN(val)) {
                        okay = false;
                        break;
                    }
                    if (ignoreInfs && Double.isInfinite(val)) {
                        okay = false;
                        break;
                    }
                    vals[j] = val;
                    ++j;
                }
                if (!okay) continue;
                j = 0;
                while (j < this.isize) {
                    val = vals[j];
                    istats[j].addValue(val);
                    this.hash = (int)((long)(this.hash * 19) + Double.doubleToRawLongBits(val));
                    ++j;
                }
            }
            lmax = new double[this.isize];
            lmin = new double[this.isize];
            lsum = new double[this.isize];
            j = 0;
            while (j < this.isize) {
                stats = istats[j];
                lmax[j] = stats.getMax();
                lmin[j] = stats.getMin();
                lsum[j] = stats.getSum();
                ++j;
            }
            mm.maximum = (T)lmax;
            mm.minimum = (T)lmin;
            mm.sum = (T)lsum;
        }
        this.hash = this.hash * 19 + this.clazz.hashCode() * 17 + this.isize;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
        return istats;
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isDirty(Dataset dataset) {
        if (this.isDirty) {
            return true;
        }
        if (this.dataset != dataset) {
            this.dataset = dataset;
        }
        return false;
    }

    private void clearAll() {
        this.hash = 0;
        int i = 0;
        while (i < this.summaries.length) {
            this.summaries[i] = null;
            this.mms[i] = null;
            ++i;
        }
        this.axisStats.clear();
    }

    @Override
    public StatisticsMetadataImpl<T> clone() {
        return new StatisticsMetadataImpl<T>(this);
    }

    @Override
    public int getHash(int[] shape) {
        if (this.isDirty || this.hash == 0) {
            this.isDirty = true;
            this.refresh(true, new boolean[0]);
        }
        int rank = shape == null ? 0 : shape.length;
        int shash = this.hash;
        int i = 0;
        while (i < rank) {
            shash = shash * 17 + shape[i];
            ++i;
        }
        return shash;
    }

    @Override
    public void setHash(int hash) {
        this.hash = hash;
    }

    @Override
    public T getSum(boolean ... ignoreInvalids) {
        int idx = this.refresh(this.isize == 1, ignoreInvalids);
        return this.mms[idx].sum;
    }

    @Override
    public T getMaximum(boolean ... ignoreInvalids) {
        int idx = this.refresh(this.isize == 1, ignoreInvalids);
        return this.mms[idx].maximum;
    }

    @Override
    public void setMaximumMinimum(T maximum, T minimum, boolean ... ignoreInvalids) {
        this.setMaximumMinimumSum(maximum, minimum, null, ignoreInvalids);
    }

    @Override
    public void setMaximumMinimumSum(T maximum, T minimum, T sum, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        MaxMin<T> mm = this.mms[idx];
        mm.maximum = maximum;
        mm.minimum = minimum;
        mm.sum = sum;
        mm.maximumPositions = null;
        mm.minimumPositions = null;
    }

    @Override
    public void setMaximumPositions(List<int[]> maximumPositions, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        this.mms[idx].maximumPositions = maximumPositions;
    }

    @Override
    public List<int[]> getMaximumPositions(boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        return this.mms[idx].maximumPositions;
    }

    @Override
    public T getMinimum(boolean ... ignoreInvalids) {
        int idx = this.refresh(this.isize == 1, ignoreInvalids);
        return this.mms[idx].minimum;
    }

    @Override
    public List<int[]> getMinimumPositions(boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        return this.mms[idx].minimumPositions;
    }

    @Override
    public void setMinimumPositions(List<int[]> minimumPositions, boolean ... ignoreInvalids) {
        int idx = this.refresh(true, ignoreInvalids);
        this.mms[idx].minimumPositions = minimumPositions;
    }

    @Override
    public long getCount(boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        return this.summaries[idx][0].getN();
    }

    @Override
    public T getMean(boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        SummaryStatistics[] summary = this.summaries[idx];
        if (this.isize == 1) {
            return (T)Double.valueOf(summary[0].getMean());
        }
        double[] result = new double[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = summary[i].getMean();
            ++i;
        }
        return (T)result;
    }

    @Override
    public double getVariance(boolean isWholePopulation, boolean ... ignoreInvalids) {
        int idx = this.refresh(false, ignoreInvalids);
        SummaryStatistics[] summary = this.summaries[idx];
        if (this.isize == 1) {
            return isWholePopulation ? summary[0].getPopulationVariance() : summary[0].getVariance();
        }
        double result = 0.0;
        int i = 0;
        while (i < this.isize) {
            result += isWholePopulation ? summary[i].getPopulationVariance() : summary[i].getVariance();
            ++i;
        }
        return result;
    }

    private int refresh(int axis, boolean ... ignoreInvalids) {
        return this.refresh(new int[]{axis}, ignoreInvalids);
    }

    private int refresh(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset;
        Axes a;
        Dataset[][] as;
        axes = ShapeUtils.checkAxes(this.dataset.getRank(), axes);
        boolean ignoreNaNs = false;
        boolean ignoreInfs = false;
        if (this.isFloat) {
            ignoreNaNs = ignoreInvalids != null && ignoreInvalids.length > 0 ? ignoreInvalids[0] : false;
            boolean bl = ignoreInfs = ignoreInvalids != null && ignoreInvalids.length > 1 ? ignoreInvalids[1] : ignoreNaNs;
        }
        if (this.isDirty) {
            this.clearAll();
        }
        if ((as = this.axisStats.get(a = new Axes(axes))) == null) {
            as = new Dataset[4][];
            this.axisStats.put(a, as);
        }
        if (as[axisOffset = (ignoreNaNs ? 1 : 0) * 2 + (ignoreInfs ? 1 : 0)] == null) {
            as[axisOffset] = this.createAxisStats(axes, ignoreNaNs, ignoreInfs);
        }
        this.isDirty = false;
        return axisOffset;
    }

    /*
     * Unable to fully structure code
     */
    private Dataset[] createAxisStats(int[] axes, boolean ignoreNaNs, boolean ignoreInfs) {
        block33: {
            block31: {
                siter = new SliceNDIterator(new SliceND(this.dataset.getShapeRef()), axes);
                nshape = siter.getUsedSlice().getSourceShape();
                count = DatasetFactory.zeros(LongDataset.class, nshape);
                if (this.isize == 1) {
                    max = DatasetFactory.zeros(this.clazz, nshape);
                    min = DatasetFactory.zeros(this.clazz, nshape);
                    maxIndex = axes.length == 1 ? DatasetFactory.zeros(IntegerDataset.class, nshape) : null;
                    minIndex = axes.length == 1 ? DatasetFactory.zeros(IntegerDataset.class, nshape) : null;
                    sum = DatasetFactory.zeros(DTypeUtils.getLargestDataset(this.clazz), nshape);
                    mean = DatasetFactory.zeros(DoubleDataset.class, nshape);
                    var = DatasetFactory.zeros(DoubleDataset.class, nshape);
                } else {
                    max = null;
                    min = null;
                    maxIndex = null;
                    minIndex = null;
                    sum = DatasetFactory.zeros(this.isize, DTypeUtils.getLargestDataset(this.clazz), nshape);
                    mean = DatasetFactory.zeros(this.isize, CompoundDoubleDataset.class, nshape);
                    var = DatasetFactory.zeros(this.isize, CompoundDoubleDataset.class, nshape);
                }
                spos = siter.getUsedPos();
                index = -1;
                if (this.isize != 1) break block31;
                lmean = (DoubleDataset)mean;
                lvar = (DoubleDataset)var;
                stats = new SummaryStatistics();
                while (siter.hasNext()) {
                    block30: {
                        block32: {
                            ++index;
                            stats.clear();
                            stats.setSumLogImpl((StorelessUnivariateStatistic)new NullStorelessUnivariateStatistic());
                            amax = -Infinity;
                            amin = Infinity;
                            hasNaNs = false;
                            iter = this.dataset.getSliceIterator(siter.getCurrentSlice());
                            if (!ignoreNaNs) ** GOTO lbl64
                            while (iter.hasNext()) {
                                val = this.dataset.getElementDoubleAbs(iter.index);
                                if (Double.isNaN(val)) {
                                    hasNaNs = true;
                                    continue;
                                }
                                if (ignoreInfs && Double.isInfinite(val)) continue;
                                if (val > amax) {
                                    amax = val;
                                }
                                if (val < amin) {
                                    amin = val;
                                }
                                stats.addValue(val);
                            }
                            break block32;
lbl-1000:
                            // 1 sources

                            {
                                val = this.dataset.getElementDoubleAbs(iter.index);
                                if (hasNaNs) {
                                    if (Double.isNaN(val)) continue;
                                    stats.addValue(0.0);
                                    continue;
                                }
                                if (Double.isNaN(val)) {
                                    amax = NaN;
                                    amin = NaN;
                                    hasNaNs = true;
                                } else {
                                    if (ignoreInfs && Double.isInfinite(val)) continue;
                                    if (val > amax) {
                                        amax = val;
                                    }
                                    if (val < amin) {
                                        amin = val;
                                    }
                                }
                                stats.addValue(val);
lbl64:
                                // 5 sources

                                ** while (iter.hasNext())
                            }
                        }
                        count.setAbs(index, stats.getN());
                        max.set((Object)amax, spos);
                        min.set((Object)amin, spos);
                        if (maxIndex == null || minIndex == null) break block30;
                        fmax = false;
                        fmin = false;
                        iter.reset();
                        i = -1;
                        if (!hasNaNs) ** GOTO lbl109
                        if (!ignoreNaNs) ** GOTO lbl97
                        while (iter.hasNext()) {
                            ++i;
                            val = this.dataset.getElementDoubleAbs(iter.index);
                            if (Double.isNaN(val)) continue;
                            if (!fmax && val == amax) {
                                maxIndex.setAbs(index, i);
                                fmax = true;
                                if (fmin) break block30;
                            }
                            if (fmin || val != amin) continue;
                            minIndex.setAbs(index, i);
                            fmin = true;
                            if (!fmax) {
                                continue;
                            }
                            break block30;
                        }
                        break block30;
lbl-1000:
                        // 1 sources

                        {
                            ++i;
                            val = this.dataset.getElementDoubleAbs(iter.index);
                            if (!Double.isNaN(val)) continue;
                            maxIndex.setAbs(index, i);
                            minIndex.setAbs(index, i);
                            break block30;
lbl97:
                            // 2 sources

                            ** while (iter.hasNext())
                        }
lbl98:
                        // 1 sources

                        break block30;
lbl-1000:
                        // 1 sources

                        {
                            ++i;
                            val = this.dataset.getElementDoubleAbs(iter.index);
                            if (!fmax && val == amax) {
                                maxIndex.setAbs(index, i);
                                fmax = true;
                                if (fmin) break;
                            }
                            if (fmin || val != amin) continue;
                            minIndex.setAbs(index, i);
                            fmin = true;
                            if (fmax) break;
lbl109:
                            // 3 sources

                            ** while (iter.hasNext())
                        }
                    }
                    sum.setObjectAbs(index, stats.getSum());
                    lmean.setAbs(index, stats.getMean());
                    lvar.setAbs(index, stats.getVariance());
                }
                break block33;
            }
            ldataset = (CompoundDataset)this.dataset;
            lmean = mean;
            lvar = var;
            darray = new double[this.isize];
            while (siter.hasNext()) {
                ++index;
                stats = new SummaryStatistics[this.isize];
                k = 0;
                while (k < this.isize) {
                    stats[k] = new SummaryStatistics();
                    ++k;
                }
                iter = this.dataset.getSliceIterator(siter.getCurrentSlice());
                pos = iter.getPos();
                while (iter.hasNext()) {
                    ldataset.getDoubleArray(darray, pos);
                    skip = false;
                    k = 0;
                    while (k < this.isize) {
                        v = darray[k];
                        if (ignoreNaNs && Double.isNaN(v)) {
                            skip = true;
                            break;
                        }
                        if (ignoreInfs && Double.isInfinite(v)) {
                            skip = true;
                            break;
                        }
                        ++k;
                    }
                    if (skip) continue;
                    k = 0;
                    while (k < this.isize) {
                        stats[k].addValue(darray[k]);
                        ++k;
                    }
                }
                count.setAbs(index, (int)stats[0].getN());
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getSum();
                    ++k;
                }
                sum.set((Object)darray, spos);
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getMean();
                    ++k;
                }
                lmean.setItem(darray, spos);
                k = 0;
                while (k < this.isize) {
                    darray[k] = stats[k].getVariance();
                    ++k;
                }
                lvar.setItem(darray, spos);
            }
        }
        return new Dataset[]{max, min, maxIndex, minIndex, count, mean, sum, var};
    }

    private Dataset getAxisStat(int axis, int offset, int item) {
        return this.getAxesStat(new int[]{axis}, offset, item);
    }

    private Dataset getAxesStat(int[] axes, int offset, int item) {
        axes = ShapeUtils.checkAxes(this.dataset.getRank(), axes);
        return this.axisStats.get(new Axes(axes))[offset][item];
    }

    @Override
    public Dataset getArgMaximum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 2);
    }

    @Override
    public Dataset getArgMinimum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 3);
    }

    @Override
    public Dataset getMaximum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 0);
    }

    @Override
    public Dataset getMinimum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 1);
    }

    @Override
    public Dataset getCount(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 4);
    }

    @Override
    public Dataset getMean(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 5);
    }

    @Override
    public Dataset getSum(int axis, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        return this.getAxisStat(axis, axisOffset, 6);
    }

    @Override
    public Dataset getVariance(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axis, ignoreInvalids);
        Dataset v = this.getAxisStat(axis, axisOffset, 7);
        if (isWholePopulation) {
            Dataset c = this.getAxisStat(axis, axisOffset, 4);
            v = Maths.multiply(v, Maths.subtract(c, 1.0).idivide(c));
        }
        return v;
    }

    @Override
    public Dataset getMaximum(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        return this.getAxesStat(axes, axisOffset, 0);
    }

    @Override
    public Dataset getMinimum(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        return this.getAxesStat(axes, axisOffset, 1);
    }

    @Override
    public Dataset getCount(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        return this.getAxesStat(axes, axisOffset, 4);
    }

    @Override
    public Dataset getMean(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        return this.getAxesStat(axes, axisOffset, 5);
    }

    @Override
    public Dataset getSum(int[] axes, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        return this.getAxesStat(axes, axisOffset, 6);
    }

    @Override
    public Dataset getVariance(int[] axes, boolean isWholePopulation, boolean ... ignoreInvalids) {
        int axisOffset = this.refresh(axes, ignoreInvalids);
        Dataset v = this.getAxesStat(axes, axisOffset, 7);
        if (isWholePopulation) {
            Dataset c = this.getAxesStat(axes, axisOffset, 4);
            v = Maths.multiply(v, Maths.subtract(c, 1.0).idivide(c));
        }
        return v;
    }

    private static class MaxMin<T>
    implements Serializable {
        private static final long serialVersionUID = -8707875904521260325L;
        T maximum;
        T minimum;
        T sum;
        List<int[]> maximumPositions;
        List<int[]> minimumPositions;

        private MaxMin() {
        }
    }
}

