/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.BooleanBroadcastIterator;
import org.eclipse.january.dataset.BooleanContiguousIterator;
import org.eclipse.january.dataset.BooleanNullIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.IndexIterator;

public abstract class BooleanIterator
extends IndexIterator {
    protected final boolean value;
    public int cIndex;
    public int oIndex;
    protected Dataset oDataset;
    protected final boolean outputA;
    protected int[] maxShape;
    protected final int aStep;
    protected int oStep;
    protected int aMax;
    protected int aStart;
    protected int oStart;
    protected Dataset aDataset;
    protected Dataset cDataset;

    public static BooleanIterator createIterator(Dataset a, Dataset c) {
        return BooleanIterator.createIterator(true, a, c, null, false);
    }

    public static BooleanIterator createIterator(Dataset a, Dataset c, Dataset o) {
        return BooleanIterator.createIterator(true, a, c, o, false);
    }

    public static BooleanIterator createIterator(boolean v, Dataset a, Dataset c, Dataset o) {
        return BooleanIterator.createIterator(v, a, c, o, false);
    }

    public static BooleanIterator createIterator(boolean v, Dataset a, Dataset c, Dataset o, boolean createIfNull) {
        if (c == null) {
            return new BooleanNullIterator(a, o, createIfNull);
        }
        if (Arrays.equals(a.getShapeRef(), c.getShapeRef()) && a.getStrides() == null && c.getStrides() == null && (o == null || o.getStrides() == null && Arrays.equals(a.getShapeRef(), o.getShapeRef()))) {
            return new BooleanContiguousIterator(v, a, c, o, createIfNull);
        }
        return new BooleanBroadcastIterator(v, a, c, o, createIfNull);
    }

    public Dataset getChoice() {
        return this.cDataset;
    }

    @Override
    public int[] getShape() {
        return this.maxShape;
    }

    protected BooleanIterator(boolean v, Dataset a, Dataset c, Dataset o) {
        this.value = v;
        this.aDataset = a;
        this.aStep = a.getElementsPerItem();
        this.cDataset = c;
        this.oDataset = o;
        boolean bl = this.outputA = a == o;
        if (c != null && c == o) {
            throw new IllegalArgumentException("Output dataset must not be same as mask dataset");
        }
        if (c != null) {
            BroadcastUtils.checkItemSize(a, c, o);
        } else if (o != null) {
            BroadcastUtils.checkItemSize(a, o);
        }
        if (o != null) {
            o.setDirty();
        }
    }

    public Dataset getOutput() {
        return this.oDataset;
    }
}

