/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.DataEvent;
import org.eclipse.january.dataset.DataListenerDelegate;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.IDataListener;
import org.eclipse.january.dataset.IDatasetChangeChecker;
import org.eclipse.january.dataset.IDynamicDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.io.ILazyDynamicLoader;
import org.eclipse.january.io.ILazyLoader;

public class LazyDynamicDataset
extends LazyDataset
implements IDynamicDataset {
    private static final long serialVersionUID = -6296506563932840938L;
    protected int[] maxShape;
    protected transient DataListenerDelegate eventDelegate;
    protected IDatasetChangeChecker checker;
    private transient PeriodicRunnable runner = new PeriodicRunnable();
    private Thread checkingThread;

    @Deprecated
    public LazyDynamicDataset(String name, int dtype, int elements, int[] shape, int[] maxShape, ILazyLoader loader) {
        this(name, elements, DTypeUtils.getInterface(dtype), shape, maxShape, loader);
    }

    @Deprecated
    public LazyDynamicDataset(String name, int elements, Class<? extends Dataset> clazz, int[] shape, int[] maxShape, ILazyLoader loader) {
        this(loader, name, elements, clazz, shape, maxShape);
    }

    public LazyDynamicDataset(ILazyLoader loader, String name, int elements, Class<? extends Dataset> clazz, int[] shape, int[] maxShape) {
        super(loader, name, elements, clazz, shape);
        if (maxShape == null) {
            this.maxShape = (int[])shape.clone();
            int rank = shape.length;
            boolean isUnlimited = false;
            int i = 0;
            while (i < rank) {
                if (shape[i] == -1) {
                    isUnlimited = true;
                    break;
                }
                ++i;
            }
            if (isUnlimited) {
                i = 0;
                while (i < rank) {
                    this.shape[i] = 0;
                    this.oShape[i] = 0;
                    ++i;
                }
            }
        } else {
            this.maxShape = (int[])maxShape.clone();
        }
        this.eventDelegate = new DataListenerDelegate();
    }

    protected LazyDynamicDataset(LazyDynamicDataset other) {
        super(other);
        this.maxShape = other.maxShape;
        this.eventDelegate = other.eventDelegate;
        this.checker = other.checker;
        this.runner = other.runner;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checker == null ? 0 : this.checker.hashCode());
        result = 31 * result + (this.checkingThread == null ? 0 : this.checkingThread.hashCode());
        result = 31 * result + Arrays.hashCode(this.maxShape);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LazyDynamicDataset other = (LazyDynamicDataset)obj;
        if (!Arrays.equals(this.maxShape, other.maxShape)) {
            return false;
        }
        if (this.checker == null ? other.checker != null : !this.checker.equals(other.checker)) {
            return false;
        }
        return !(this.checkingThread == null ? other.checkingThread != null : !this.checkingThread.equals(other.checkingThread));
    }

    @Override
    public ILazyDataset getDataset() {
        return this;
    }

    @Override
    public void addDataListener(IDataListener l) {
        this.eventDelegate.addDataListener(l);
    }

    @Override
    public void removeDataListener(IDataListener l) {
        this.eventDelegate.removeDataListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireDataListeners() {
        DataListenerDelegate dataListenerDelegate = this.eventDelegate;
        synchronized (dataListenerDelegate) {
            this.eventDelegate.fire(new DataEvent(this.name, this.shape));
        }
    }

    @Override
    public boolean refreshShape() {
        if (this.loader instanceof ILazyDynamicLoader) {
            return this.resize(((ILazyDynamicLoader)((Object)this.loader)).refreshShape());
        }
        return false;
    }

    @Override
    public boolean resize(int ... newShape) {
        int rank = this.shape.length;
        if (newShape.length != rank) {
            throw new IllegalArgumentException("Rank of new shape must match current shape");
        }
        if (Arrays.equals(this.shape, newShape)) {
            return false;
        }
        if (this.maxShape != null) {
            int i = 0;
            while (i < rank) {
                int m = this.maxShape[i];
                if (m != -1 && newShape[i] > m) {
                    throw new IllegalArgumentException("A dimension of new shape must not exceed maximum shape");
                }
                ++i;
            }
        }
        this.shape = (int[])newShape.clone();
        this.oShape = this.shape;
        try {
            this.size = ShapeUtils.calcLongSize(this.shape);
        }
        catch (IllegalArgumentException e) {
            this.size = Long.MAX_VALUE;
        }
        this.eventDelegate.fire(new DataEvent(this.name, this.shape));
        return true;
    }

    @Override
    public int[] getMaxShape() {
        return this.maxShape;
    }

    @Override
    public void setMaxShape(int ... maxShape) {
        int[] nArray = this.maxShape = maxShape == null ? (int[])this.shape.clone() : (int[])maxShape.clone();
        if (this.maxShape.length > this.oShape.length) {
            this.oShape = LazyDynamicDataset.prependShapeWithOnes(this.maxShape.length, this.oShape);
        }
        if (this.maxShape.length > this.shape.length) {
            this.shape = LazyDynamicDataset.prependShapeWithOnes(this.maxShape.length, this.shape);
        }
    }

    private static final int[] prependShapeWithOnes(int rank, int[] shape) {
        int[] nShape = new int[rank];
        int excess = rank - shape.length;
        int i = 0;
        while (i < excess) {
            nShape[i] = 1;
            ++i;
        }
        i = excess;
        while (i < nShape.length) {
            nShape[i] = shape[i - excess];
            ++i;
        }
        return nShape;
    }

    @Override
    public LazyDynamicDataset clone() {
        return new LazyDynamicDataset(this);
    }

    @Override
    public synchronized void startUpdateChecker(int milliseconds, IDatasetChangeChecker checker) {
        if (this.checkingThread != null) {
            this.checkingThread.interrupt();
        }
        this.checker = checker;
        if (checker != null) {
            checker.setDataset(this);
        }
        if (milliseconds <= 0) {
            return;
        }
        this.runner.millis = milliseconds;
        this.checkingThread = new Thread(this.runner);
        this.checkingThread.setDaemon(true);
        this.checkingThread.setName("Checking thread with period " + milliseconds + "ms");
        this.checkingThread.start();
    }

    class PeriodicRunnable
    implements Runnable {
        long millis;

        PeriodicRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (LazyDynamicDataset.this.checker != null && !LazyDynamicDataset.this.checker.check()) continue;
                LazyDynamicDataset.this.fireDataListeners();
            }
        }
    }
}

