/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.MedianForSn;
import org.eclipse.january.dataset.MedianOfTwoArrays;
import org.eclipse.january.dataset.Stats;

public class Outliers {
    private static final double MADSCALEFACTOR = 1.4826;
    private static final double SNSCALEFACTOR = 1.1926;

    public static double[] medianAbsoluteDeviation(Dataset data) {
        double median = (Double)Stats.median(data);
        data = Maths.subtract(data, median);
        data = Maths.abs(data);
        double median2 = (Double)Stats.median(data);
        double mad = 1.4826 * median2;
        return new double[]{mad, median};
    }

    public static double snNaive(Dataset data) {
        Dataset medAbs = DatasetFactory.zeros(data);
        Dataset dif = DatasetFactory.zeros(data);
        IndexIterator it = data.getIterator();
        int count = 0;
        while (it.hasNext()) {
            double val = data.getElementDoubleAbs(it.index);
            Maths.subtract(data, val, dif);
            Maths.abs(dif, dif);
            dif.sort(null);
            medAbs.setObjectAbs(count++, Outliers.lowMed(dif));
        }
        medAbs.sort(null);
        double median = Outliers.highMed(medAbs);
        return median * 1.1926;
    }

    public static double snFast(Dataset data) {
        Dataset sorted = data.clone();
        sorted.sort(null);
        Dataset medAbs = DatasetFactory.zeros(data);
        IndexIterator it = data.getIterator();
        int count = 0;
        while (it.hasNext()) {
            MedianForSn snuff = new MedianForSn(sorted, it.index);
            medAbs.setObjectAbs(count++, snuff.get());
        }
        medAbs.sort(null);
        double median = Outliers.highMed(medAbs);
        return median * 1.1926;
    }

    public static double lowMed(Dataset data) {
        return data.getElementDoubleAbs((int)Math.floor(data.getSize() / 2));
    }

    public static double highMed(Dataset data) {
        return data.getElementDoubleAbs((int)Math.floor((data.getSize() + 1) / 2 - 1));
    }

    public static double medianOFTwoPrimitiveArrays(double[] a, double[] b) {
        MedianOfTwoArrays medio = new MedianOfTwoArrays(a, b);
        return medio.get();
    }
}

