/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EndBatchedTransactionExtendedResult
extends ExtendedResult {
    private static final long serialVersionUID = 1514265185948328221L;
    private final int failedOpMessageID;
    private final TreeMap<Integer, Control[]> opResponseControls;

    public EndBatchedTransactionExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1Sequence valueSequence;
        this.opResponseControls = new TreeMap();
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.failedOpMessageID = -1;
            return;
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_VALUE_NOT_SEQUENCE.get(ae.getMessage()), ae);
        }
        ASN1Element[] valueElements = valueSequence.elements();
        if (valueElements.length == 0) {
            this.failedOpMessageID = -1;
            return;
        }
        if (valueElements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_INVALID_ELEMENT_COUNT.get(valueElements.length));
        }
        int msgID = -1;
        for (ASN1Element e : valueElements) {
            if (e.getType() == 2) {
                try {
                    msgID = ASN1Integer.decodeAsInteger(e).intValue();
                    continue;
                }
                catch (ASN1Exception ae) {
                    Debug.debugException(ae);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CANNOT_DECODE_MSGID.get(ae), ae);
                }
            }
            if (e.getType() == 48) {
                EndBatchedTransactionExtendedResult.decodeOpControls(e, this.opResponseControls);
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_INVALID_TYPE.get(StaticUtils.toHex(e.getType())));
        }
        this.failedOpMessageID = msgID;
    }

    public EndBatchedTransactionExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Integer failedOpMessageID, Map<Integer, Control[]> opResponseControls, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, EndBatchedTransactionExtendedResult.encodeValue(failedOpMessageID, opResponseControls), responseControls);
        this.failedOpMessageID = failedOpMessageID == null || failedOpMessageID <= 0 ? -1 : failedOpMessageID;
        this.opResponseControls = opResponseControls == null ? new TreeMap() : new TreeMap<Integer, Control[]>(opResponseControls);
    }

    private static void decodeOpControls(ASN1Element element, Map<Integer, Control[]> controlMap) throws LDAPException {
        ASN1Sequence ctlsSequence;
        try {
            ctlsSequence = ASN1Sequence.decodeAsSequence(element);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CONTROLS_NOT_SEQUENCE.get(ae), ae);
        }
        for (ASN1Element e : ctlsSequence.elements()) {
            ASN1Sequence controlsSequence;
            int msgID;
            ASN1Sequence ctlSequence;
            try {
                ctlSequence = ASN1Sequence.decodeAsSequence(e);
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CONTROL_NOT_SEQUENCE.get(ae), ae);
            }
            ASN1Element[] ctlSequenceElements = ctlSequence.elements();
            if (ctlSequenceElements.length != 2) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CONTROL_INVALID_ELEMENT_COUNT.get(ctlSequenceElements.length));
            }
            try {
                msgID = ASN1Integer.decodeAsInteger(ctlSequenceElements[0]).intValue();
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CONTROL_MSGID_NOT_INT.get(ae), ae);
            }
            try {
                controlsSequence = ASN1Sequence.decodeAsSequence(ctlSequenceElements[1]);
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_RESPONSE_CONTROLS_ELEMENT_NOT_SEQUENCE.get(ae), ae);
            }
            Control[] controls = Control.decodeControls(controlsSequence);
            if (controls.length == 0) continue;
            controlMap.put(msgID, controls);
        }
    }

    private static ASN1OctetString encodeValue(Integer failedOpMessageID, Map<Integer, Control[]> opResponseControls) {
        if (failedOpMessageID == null && opResponseControls == null) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (failedOpMessageID != null) {
            elements.add(new ASN1Integer(failedOpMessageID));
        }
        if (opResponseControls != null && !opResponseControls.isEmpty()) {
            ArrayList<ASN1Sequence> controlElements = new ArrayList<ASN1Sequence>();
            for (Map.Entry<Integer, Control[]> e : opResponseControls.entrySet()) {
                ASN1Element[] ctlElements = new ASN1Element[]{new ASN1Integer(e.getKey()), Control.encodeControls(e.getValue())};
                controlElements.add(new ASN1Sequence(ctlElements));
            }
            elements.add(new ASN1Sequence(controlElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public int getFailedOpMessageID() {
        return this.failedOpMessageID;
    }

    public Map<Integer, Control[]> getOperationResponseControls() {
        return this.opResponseControls;
    }

    public Control[] getOperationResponseControls(int messageID) {
        return this.opResponseControls.get(messageID);
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_END_BATCHED_TXN.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("EndBatchedTransactionExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.failedOpMessageID > 0) {
            buffer.append(", failedOpMessageID=");
            buffer.append(this.failedOpMessageID);
        }
        if (!this.opResponseControls.isEmpty()) {
            buffer.append(", opResponseControls={");
            for (int msgID : this.opResponseControls.keySet()) {
                buffer.append("opMsgID=");
                buffer.append(msgID);
                buffer.append(", opControls={");
                boolean first = true;
                for (Control c : this.opResponseControls.get(msgID)) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append(c);
                }
                buffer.append('}');
            }
            buffer.append('}');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

