/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMProject;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = colAttrib.getCollectionType();
                this.logTrace("collection Type = " + colAttrib.getCollectionType());
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    this.logTrace("Received Expected Collection type = " + pluralColType);
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Collection type = " + pluralColType);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                this.logTrace("collection Element Type = " + colAttrib.getElementType().getJavaType().getName());
                String elementTypeName = colAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMProject")) {
                    this.logTrace("Received Expected Element type = " + elementTypeName);
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Element type = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("in cleanup");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception fe) {
            this.logErr("Unexpected exception rolling back TX:", fe);
        }
        this.logTrace("done cleanup, calling super.cleanup");
        super.cleanup();
    }
}

