/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet1;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet1";
    private TSNamingContextInterface jc = null;
    private transient Connection coffeeCon = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private ResultSet rs = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private int rscount = 0;
    private ResultSet rs1 = null;
    private String query1 = null;
    private int rowMaxVal = 0;
    private String query = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient1 theTests = new resultSetClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                String fTableName = p.getProperty("ftable", "");
                this.msg = new JDBCTestMsg();
                this.query = p.getProperty("SelCoffeeAll", "");
                if (this.query.length() == 0) {
                    throw new Exception("Invalid SQL Statement ");
                }
                this.msg.setMsg("Query to select All the rows :" + this.query);
                this.query1 = p.getProperty("SelCoffeeNull", "");
                if (this.query1.length() == 0) {
                    throw new Exception("Invalid SQL Statement ");
                }
                this.msg.setMsg("Query to select Null rows :" + this.query1);
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.coffeeCon = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.coffeeCon = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.coffeeCon);
                this.stmt = this.coffeeCon.createStatement();
                this.rs = this.stmt.executeQuery(this.query.trim());
            }
            catch (SQLException ex) {
                this.msg.printSQLError(ex, "");
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!", e);
        }
    }

    public int rsCount(ResultSet rs) throws Exception {
        int count = 0;
        try {
            while (rs.next()) {
                ++count;
            }
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to rsCount is Failed!");
        }
        return count;
    }

    public void testGetConcurrency() throws Exception {
        try {
            this.msg.setMsg("Calling getConcurrency on ResultSet");
            int concurrencyValue = this.rs.getConcurrency();
            if (concurrencyValue == 1007) {
                this.msg.setMsg("getConcurrency method returns ResultSet.CONCUR_READ_ONLY ");
            } else if (concurrencyValue == 1008) {
                this.msg.setMsg("getConcurrency method returns ResultSet.CONCUR_UPDATABLE");
            } else {
                this.msg.printTestError(" getConcurrency method returns a invalid value", "Call to getConcurrency is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getConcurrency is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getConcurrency is Failed!");
        }
    }

    public void testGetFetchDirection() throws Exception {
        try {
            this.msg.setMsg("Calling getFetchDirection on ResultSet");
            int fetchDirectionValue = this.rs.getFetchDirection();
            if (fetchDirectionValue == 1000) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_FORWARD ");
            } else if (fetchDirectionValue == 1001) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_REVERSE");
            } else if (fetchDirectionValue == 1002) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_UNKNOWN");
            } else {
                this.msg.printTestError(" getFetchDirection method returns a invalid value", "Call to getFetchDirection is Failed");
            }
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFetchDirection is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFetchDirection is Failed!");
        }
    }

    public void testGetFetchSize() throws Exception {
        try {
            this.msg.setMsg("Calling getFetchSize on ResultSet");
            int fetchSizeValue = this.rs.getFetchSize();
            if (fetchSizeValue >= 0) {
                this.msg.setMsg("getFetchSize method returns :" + fetchSizeValue);
            } else {
                this.msg.setMsg(" getFetchSize method returns a invalid value");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFetchSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFetchSize is Failed!");
        }
    }

    public void testGetType() throws Exception {
        try {
            this.msg.setMsg("Calling getType on ResultSet");
            int typeValue = this.rs.getType();
            if (typeValue == 1003) {
                this.msg.setMsg("getType method returns ResultSet.TYPE_FORWARD_ONLY ");
            } else if (typeValue == 1004) {
                this.msg.setMsg("getType method returns ResultSet.TYPE_SCROLL_INSENSITIVE");
            } else if (typeValue == 1005) {
                this.msg.setMsg("getType method returns ResultSet.TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.printTestError(" getType method returns a invalid value", "Call to getType is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getType is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getType is Failed!");
        }
    }

    public void testSetFetchSize01() throws Exception {
        try {
            this.msg.setMsg("Calling setFetchSize on ResultSet");
            this.rs.setFetchSize(0);
            int fetchSizeValue = this.rs.getFetchSize();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFetchSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "setFetchSize Failed!");
        }
    }

    public void testSetFetchSize02() throws Exception {
        try {
            Statement stmt = this.coffeeCon.createStatement();
            stmt.setMaxRows(5);
            ResultSet rs = stmt.executeQuery(this.query.trim());
            this.rowMaxVal = stmt.getMaxRows();
            this.msg.setMsg("Calling setFetchSize() on ResultSet");
            rs.setFetchSize(this.rowMaxVal);
            int fetchSizeValue = rs.getFetchSize();
            this.msg.addOutputMsg("" + this.rowMaxVal, "" + fetchSizeValue);
            if (fetchSizeValue == this.rowMaxVal) {
                this.msg.setMsg("setFetchSize method sets number of rows that has been specified :" + fetchSizeValue);
            } else {
                this.msg.printTestError("setFetchSize method does not set number of rows that has been specified", "Call to setFetchSize is Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFetchSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "setFetchSize Failed!");
        }
    }

    public void testSetFetchSize03() throws Exception {
        boolean flag = false;
        try {
            this.rowMaxVal = this.stmt.getMaxRows();
            this.msg.setMsg("Calling setFetchSize on ResultSet");
            try {
                if (this.rowMaxVal > 0) {
                    this.rs.setFetchSize(this.rowMaxVal + 2);
                } else if (this.rowMaxVal == 0) {
                    this.msg.setMsg("Resultset supports unlimited number of rows");
                    flag = true;
                }
                this.msg.printTestMsg();
                this.msg.printOutputMsg();
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                flag = true;
            }
            if (flag) {
                this.msg.setMsg("setFetchSize method does not set the size greater than the Maximum Rows that ResultSet can contain");
            } else {
                this.msg.printTestError("setFetchSize method sets the size greater than the Maximum Rows that ResultSet can contain ", "Call to setFetchSize is Failed!");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "setFetchSize Failed!");
        }
    }

    public void testSetFetchSize04() throws Exception {
        boolean flag = false;
        try {
            this.msg.setMsg("Calling setFetchSize(-1) on ResultSet");
            try {
                this.rs.setFetchSize(-1);
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                flag = true;
            }
            if (flag) {
                this.msg.setMsg("setFetchSize method does not set the size as negative ");
            } else {
                this.msg.printTestError("setFetchSize method sets the size as negative ", "Call to setFetchSize is Failed!");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "setFetchSize Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.dbSch.destroyData(this.coffeeCon);
            this.dbSch.dbUnConnect(this.coffeeCon);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

