/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt16;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient16
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt16";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient16 theTests = new prepStmtClient16();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetParameterMetaData() throws Exception {
        ParameterMetaData pmd = null;
        Object rsmd = null;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Query", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            pmd = this.pstmt.getParameterMetaData();
            int numberOfParams = pmd.getParameterCount();
            this.msg.setMsg("numberOfParams" + numberOfParams);
            if (numberOfParams != 0) {
                this.msg.setMsg(" getParameterCount returns the number of parameters as" + numberOfParams);
            } else {
                this.msg.printTestError("getParameterCount does not return the number of parameters", "Test GetParameterMetaData Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMetaData is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMetaData is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetAsciiStream() throws Exception {
        String sPrepStatement = null;
        String sCoffeeName = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            sCoffeeName = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sPrepStatement = this.sqlp.getProperty("Longvarchar_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.msg.setMsg("After creating pstmt...");
            byte[] buf = sCoffeeName.getBytes();
            int len = buf.length;
            ByteArrayInputStream istr = new ByteArrayInputStream(buf);
            this.msg.setMsg("Execute pstmt.setAsciiStream");
            this.pstmt.setAsciiStream(1, (InputStream)istr, len);
            this.pstmt.executeUpdate();
            String longvarchar_query = this.sqlp.getProperty("Longvarchar_Query_Name", "");
            rs = this.stmt.executeQuery(longvarchar_query);
            rs.next();
            String retVal = (String)rs.getObject(1);
            this.msg.addOutputMsg(sCoffeeName, retVal);
            if (sCoffeeName.equalsIgnoreCase(retVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the desired value");
            } else {
                this.msg.printTestError("setAsciiStream method does not set the designated parameter with the desired value", "Call to setAsciiStream failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to SetAsciiStream is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to SetAsciiStream is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBinaryStream() throws Exception {
        Object sPrepStatement = null;
        Object sCoffeeName = null;
        ResultSet rs = null;
        byte[] retByteArr = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            String binsize = this.props.getProperty("longvarbinarySize");
            int bytearrsize = Integer.parseInt(binsize);
            this.msg.setMsg("Longvarbinary Size: " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            int len = bytearr.length;
            ByteArrayInputStream istr = new ByteArrayInputStream(bytearr);
            this.pstmt.setBinaryStream(1, (InputStream)istr, len);
            this.pstmt.executeUpdate();
            String longvarbinary_val_query = this.sqlp.getProperty("Longvarbinary_Query_Val", "");
            this.msg.setMsg(longvarbinary_val_query);
            rs = this.stmt.executeQuery(longvarbinary_val_query);
            rs.next();
            retByteArr = (byte[])rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("setBinaryStream Method does not set the designated parameter with the inputStream", "test setBinaryStream Failed");
            }
            this.msg.setMsg("setBinaryStream sets the designated parameter with the InputStream");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to SetBinaryStream is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to SetBinaryStream is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetCharacterStream() throws Exception {
        String sPrepStatement = null;
        String sCoffeeName = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            sCoffeeName = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sPrepStatement = this.sqlp.getProperty("Longvarchar_Tab_Name_Update", null);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.msg.setMsg("After creating pstmt...");
            byte[] buf = sCoffeeName.getBytes();
            int len = buf.length;
            ByteArrayInputStream chstr = new ByteArrayInputStream(buf);
            InputStreamReader istr = new InputStreamReader(chstr);
            this.msg.setMsg("Execute pstmt.setCharacterStream");
            this.pstmt.setCharacterStream(1, (Reader)istr, len);
            this.pstmt.executeUpdate();
            String longvarchar_query = this.sqlp.getProperty("Longvarchar_Query_Name", "");
            rs = this.stmt.executeQuery(longvarchar_query);
            rs.next();
            String retVal = (String)rs.getObject(1);
            this.msg.addOutputMsg(sCoffeeName, retVal);
            if (sCoffeeName.equalsIgnoreCase(retVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the desired value");
            } else {
                this.msg.printTestError("setCharacterStream method does not set the designated parameter with the desired value", "Call to setCharacterStream failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setCharacterStream is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setCharacterStream is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

