/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta2;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient2
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta2";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient2 theTests = new dbMetaClient2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testStoresMixedCaseIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesMixedCaseIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesMixedCaseIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesMixedCaseIdentifiers method returns unquoted SQL identifiers stored as mixed case");
            } else {
                this.msg.setMsg("storesMixedCaseIdentifiers method returns unquoted SQL identifiers not stored as mixed case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesMixedCaseIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesMixedCaseIdentifiers is Failed!");
        }
    }

    public void testSupportsMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling supportsMixedCaseQuotedIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsMixedCaseQuotedIdentifiers();
            if (retValue) {
                this.msg.setMsg("supportsMixedCaseQuotedIdentifiers method is supported");
            } else {
                this.msg.setMsg("supportsMixedCaseQuotedIdentifiers method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMixedCaseQuotedIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMixedCaseQuotedIdentifiers is Failed!");
        }
    }

    public void testStoresUpperCaseQuotedIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesUpperCaseQuotedIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesUpperCaseQuotedIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesUpperCaseQuotedIdentifiers method returns SQL identifiers stored as upper case");
            } else {
                this.msg.setMsg("storesUpperCaseQuotedIdentifiers method returns SQL identifiers not stored as upper case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesUpperCaseQuotedIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesUpperCaseQuotedIdentifiers is Failed!");
        }
    }

    public void testStoresLowerCaseQuotedIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesLowerCaseQuotedIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesLowerCaseQuotedIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesLowerCaseQuotedIdentifiers method returns SQL identifiers stored as lower case");
            } else {
                this.msg.setMsg("storesLowerCaseQuotedIdentifiers method returns SQL identifiers not stored as lower case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesLowerCaseQuotedIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesLowerCaseQuotedIdentifiers is Failed!");
        }
    }

    public void testStoresMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.msg.setMsg("Calling storesMixedCaseQuotedIdentifiers on DatabaseMetaData");
            boolean retValue = this.dbmd.storesMixedCaseQuotedIdentifiers();
            if (retValue) {
                this.msg.setMsg("storesMixedCaseQuotedIdentifiers method returns SQL identifiers stored as mixed case");
            } else {
                this.msg.setMsg("storesMixedCaseQuotedIdentifiers method returns SQL identifiers not stored as mixed case");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to storesMixedCaseQuotedIdentifiers is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to storesMixedCaseQuotedIdentifiers is Failed!");
        }
    }

    public void testGetIdentifierQuoteString() throws Exception {
        try {
            this.msg.setMsg("Calling getIdentifierQuoteString on DatabaseMetaData");
            String sRetValue = this.dbmd.getIdentifierQuoteString();
            if (sRetValue.equals("")) {
                this.msg.setMsg("The database does not support quoting identifiers");
            } else if (sRetValue instanceof String) {
                this.msg.setMsg("getIdentifierQuoteString method returns " + sRetValue);
            } else if (sRetValue == null) {
                this.msg.printTestError("getIdentifierQuoteString returns an Invalid value", "Call to getIdentfierQuoteString is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIdentifierQuoteString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIdentifierQuoteString is Failed!");
        }
    }

    public void testGetSQLKeywords() throws Exception {
        try {
            this.msg.setMsg("Calling getSQLKeywords on DatabaseMetaData");
            String sRetValue = this.dbmd.getSQLKeywords();
            if (sRetValue == null) {
                this.msg.setMsg("getSQLKeywords method does not returns the list of SQLKeywords ");
            } else {
                this.msg.setMsg("getSQLKeywords method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getSQLKeywords is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getSQLKeywords is Failed!");
        }
    }

    public void testGetNumericFunctions() throws Exception {
        try {
            this.msg.setMsg("Calling getNumericFunctions on DatabaseMetaData");
            String sRetValue = this.dbmd.getNumericFunctions();
            if (sRetValue == null) {
                this.msg.setMsg("getNumericFunctions method does not returns the comma-separated list of math functions ");
            } else {
                this.msg.setMsg("getNumericFunctions method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getNumericFunctions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getNumericFunctions is Failed!");
        }
    }

    public void testGetStringFunctions() throws Exception {
        try {
            this.msg.setMsg("Calling getStringFunctions on DatabaseMetaData");
            String sRetValue = this.dbmd.getStringFunctions();
            if (sRetValue == null) {
                this.msg.setMsg("getStringFunctions method does not returns the comma-separated list of string functions ");
            } else {
                this.msg.setMsg("getStringFunctions method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getStringFunctions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getStringFunctions is Failed!");
        }
    }

    public void testGetSystemFunctions() throws Exception {
        try {
            this.msg.setMsg("Calling getSystemFunctions on DatabaseMetaData");
            String sRetValue = this.dbmd.getSystemFunctions();
            if (sRetValue == null) {
                this.msg.setMsg("getSystemFunctions methd does not returns the comma-separated list of system functions ");
            } else {
                this.msg.setMsg("getSystemFunctions method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getSystemFunctions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getSystemFunctions is Failed!");
        }
    }

    public void testGetTimeDateFunctions() throws Exception {
        try {
            this.msg.setMsg("Calling getTimeDateFunctions on DatabaseMetaData");
            String sRetValue = this.dbmd.getTimeDateFunctions();
            if (sRetValue == null) {
                this.msg.setMsg("getTimeDateFunctions method does not returns the comma-separated list of time and date functions ");
            } else {
                this.msg.setMsg("getTimeDateFunctions method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimeDateFunctions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimeDateFunctions is Failed!");
        }
    }

    public void testGetSearchStringEscape() throws Exception {
        try {
            this.msg.setMsg("Calling getSearchStringEscape on DatabaseMetaData");
            String sRetValue = this.dbmd.getSearchStringEscape();
            if (sRetValue == null) {
                this.msg.setMsg("getSearchStringEscape  method does not returns the string used to escape wildcard characters ");
            } else {
                this.msg.setMsg("getSearchStringEscape method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimeDateFunctions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimeDateFunctions is Failed!");
        }
    }

    public void testGetExtraNameCharacters() throws Exception {
        try {
            this.msg.setMsg("Calling getExtraNameCharacters on DatabaseMetaData");
            String sRetValue = this.dbmd.getExtraNameCharacters();
            if (sRetValue == null) {
                this.msg.setMsg("getExtraNameCharacters method does not returns the string containing the extra characters ");
            } else {
                this.msg.setMsg("getExtraNameCharacters method returns: " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getExtraNameCharacters is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getExtraNameCharacters is Failed!");
        }
    }

    public void testSupportsAlterTableWithAddColumn() throws Exception {
        try {
            this.msg.setMsg("Calling supportsAlterTableWithAddColumn on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsAlterTableWithAddColumn();
            if (retValue) {
                this.msg.setMsg("supportsAlterTableWithAddColumn is supported");
            } else {
                this.msg.setMsg("supportsAlterTableWithAddColumn is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsAlterTableWithAddColumn is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsAlterTableWithAddColumn is Failed!");
        }
    }

    public void testSupportsAlterTableWithDropColumn() throws Exception {
        try {
            this.msg.setMsg("Calling supportsAlterTableWithDropColumn on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsAlterTableWithDropColumn();
            if (retValue) {
                this.msg.setMsg("supportsAlterTableWithDropColumn is supported");
            } else {
                this.msg.setMsg("supportsAlterTableWithDropColumn is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsAlterTableWithDropColumn is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsAlterTableWithDropColumn is Failed!");
        }
    }

    public void testSupportsColumnAliasing() throws Exception {
        try {
            this.msg.setMsg("Calling supportsColumnAliasing on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsColumnAliasing();
            this.logTrace("A JDBC CompliantTM driver always returns true");
            if (retValue) {
                this.msg.setMsg("supportsColumnAliasing is supported");
            } else {
                this.msg.printTestError("supportsColumnAliasing is not supported", "supportsColumnAliasing should always return true!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsColumnAliasing is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsColumnAliasing is Failed!");
        }
    }

    public void testNullPlusNonNullIsNull() throws Exception {
        try {
            this.msg.setMsg("Calling nullPlusNonNullIsNull on DatabaseMetaData");
            boolean retValue = this.dbmd.nullPlusNonNullIsNull();
            this.logTrace("A JDBC CompliantTM driver always returns true");
            if (retValue) {
                this.msg.setMsg("nullPlusNonNullIsNull method returns a NULL value for the concatenations between NULL and non-NULL");
            } else {
                this.msg.printTestError("nullPlusNonNullIsNull method does not returns a NULL value for the concatenations between NULL and non-NULL", "nullPlusNonNullIsNull method should always return true!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nullPlusNonNullIsNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nullPlusNonNullIsNull is Failed!");
        }
    }

    public void testSupportsConvert() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert();
            if (retValue) {
                this.msg.setMsg("supportsConvert method is supported");
            } else {
                this.msg.setMsg("supportsConvert method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert01() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(ARRAY, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2003, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(ARRAY, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(ARRAY, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert02() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(BIGINT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-5, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(BIGINT, VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BIGINT, VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

