/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.projectmanager;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.client.compiler.launcher.CompilerCreator;
import org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection.CompilerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.indexer.launcher.IndexerCreator;
import org.eclipse.mylyn.docs.intent.client.linkresolver.repository.LinkResolverCreator;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerCreator;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.ide.generatedelementlistener.IDEGeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.ui.ide.navigator.ProjectExplorerRefresher;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.exporter.client.IntentExporterClientCreator;
import org.eclipse.mylyn.docs.intent.external.parser.IntentExternalParserContributionRegistry;
import org.eclipse.mylyn.docs.intent.external.parser.client.ExternalParserCreator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class IntentProjectManager {
    private CompilerRepositoryClient compilerClient;
    private AbstractRepositoryClient externalParserClient;
    private AbstractRepositoryClient synchronizerClient;
    private AbstractRepositoryClient indexerClient;
    private AbstractRepositoryClient refresher;
    private AbstractRepositoryClient linkResolverClient;
    private AbstractRepositoryClient exporterClient;
    private IProject project;
    private Repository repository;
    private boolean isConnected;

    public IntentProjectManager(IProject project) {
        this.project = project;
    }

    public synchronized void connect() throws RepositoryConnectionException {
        block12: {
            try {
                this.repository = IntentRepositoryManager.INSTANCE.getRepository(this.project.getName());
                IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[IntentProjectManager] Connecting to project " + this.project.getName());
                if (this.project.isAccessible() && this.project.getNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature") != null) {
                    boolean shouldDisplayPReviewPage;
                    if (this.compilerClient == null) {
                        this.compilerClient = CompilerCreator.createCompilerClient((Repository)this.repository);
                    }
                    if (this.linkResolverClient == null) {
                        this.linkResolverClient = LinkResolverCreator.createLinkResolverClient((Repository)this.repository);
                    }
                    if (this.synchronizerClient == null) {
                        this.synchronizerClient = SynchronizerCreator.createSynchronizer((Repository)this.repository, (GeneratedElementListener)new IDEGeneratedElementListener());
                    }
                    if (this.indexerClient == null) {
                        this.indexerClient = IndexerCreator.createIndexer((Repository)this.repository);
                    }
                    if (this.refresher == null) {
                        this.refresher = ProjectExplorerRefresher.createProjectExplorerRefresher(this.project);
                    }
                    if (this.externalParserClient == null) {
                        this.externalParserClient = ExternalParserCreator.createParser((Repository)this.repository, (Collection)IntentExternalParserContributionRegistry.getExternalParserContributions());
                    }
                    if ((shouldDisplayPReviewPage = IntentPreferenceService.getBoolean((String)"org.eclipse.mylyn.docs.intent.client.ui.preferences.show_preview_page").booleanValue()) && this.exporterClient == null) {
                        this.exporterClient = IntentExporterClientCreator.createIntentExporterClient((Repository)this.repository);
                    }
                    this.indexerClient.handleChangeNotification(null);
                    this.compilerClient.handleChangeNotification(null);
                    this.linkResolverClient.handleChangeNotification(null);
                    if (this.exporterClient != null) {
                        this.exporterClient.handleChangeNotification(null);
                    }
                    break block12;
                }
                throw new RepositoryConnectionException("Cannot create Repository on project " + this.project.getName());
            }
            catch (CoreException e) {
                throw new RepositoryConnectionException(e.getMessage());
            }
            catch (ReadOnlyException e) {
                throw new RepositoryConnectionException(e.getMessage());
            }
        }
        this.isConnected = true;
    }

    public synchronized void disconnect() throws RepositoryConnectionException {
        if (this.isConnected) {
            this.closeRelatedEditors();
            if (this.compilerClient != null) {
                this.compilerClient.dispose();
                this.compilerClient = null;
            }
            if (this.externalParserClient != null) {
                this.externalParserClient.dispose();
                this.externalParserClient = null;
            }
            if (this.linkResolverClient != null) {
                this.linkResolverClient.dispose();
                this.linkResolverClient = null;
            }
            if (this.synchronizerClient != null) {
                this.synchronizerClient.dispose();
                this.synchronizerClient = null;
            }
            if (this.indexerClient != null) {
                this.indexerClient.dispose();
                this.indexerClient = null;
            }
            if (this.refresher != null) {
                this.refresher.dispose();
                this.refresher = null;
            }
            if (this.exporterClient != null) {
                this.exporterClient.dispose();
                this.exporterClient = null;
            }
            this.repository.closeSession();
        }
        IntentRepositoryManager.INSTANCE.deleteRepository(this.project.getName());
    }

    private void closeRelatedEditors() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    IEditorReference[] references;
                    IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                    IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                    int n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference reference = iEditorReferenceArray[n2];
                        IEditorPart part = reference.getEditor(false);
                        if (part instanceof IntentEditor) {
                            IntentEditor editor = (IntentEditor)part;
                            IntentDocumentProvider provider = (IntentDocumentProvider)editor.getDocumentProvider();
                            if (IntentProjectManager.this.repository.equals(provider.getRepository())) {
                                editor.close(editor.isSaveOnCloseNeeded());
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
    }
}

