/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentSelectionUtil {
    private IntentSelectionUtil() {
    }

    public static Collection<IntentStructuredElement> getIntentElements(Object receiver) {
        Collection<? extends Object> selectedObjects = IntentSelectionUtil.getSelectedObjects(receiver);
        LinkedHashSet correspondingIntentElements = Sets.newLinkedHashSet();
        for (Object object : selectedObjects) {
            if (IntentSelectionUtil.isIntentProject(object)) {
                IntentDocument intentDocumentFromProject = IntentSelectionUtil.getIntentDocumentFromProject(IntentSelectionUtil.getIntentProjectName(object));
                if (intentDocumentFromProject == null) continue;
                correspondingIntentElements.add(intentDocumentFromProject);
                continue;
            }
            IntentStructuredElement correspondingElement = null;
            EObject correspondingEObject = null;
            if (object instanceof EObject) {
                correspondingEObject = (EObject)object;
            }
            if (object instanceof IAdaptable) {
                correspondingEObject = (EObject)((IAdaptable)object).getAdapter(EObject.class);
            }
            if (correspondingEObject instanceof IntentStructuredElement) {
                correspondingElement = (IntentStructuredElement)correspondingEObject;
            }
            if (correspondingEObject instanceof IntentIndexEntry && ((IntentIndexEntry)correspondingEObject).getReferencedElement() instanceof IntentStructuredElement) {
                correspondingElement = (IntentStructuredElement)((IntentIndexEntry)correspondingEObject).getReferencedElement();
            }
            if (correspondingElement == null) continue;
            correspondingIntentElements.add(correspondingElement);
        }
        return correspondingIntentElements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IntentDocument getIntentDocumentFromProject(String projectName) {
        IntentDocument correspondingDocument = null;
        RepositoryAdapter repositoryAdapter = null;
        try {
            try {
                Repository repository = IntentRepositoryManager.INSTANCE.getRepository(projectName);
                if (repository == null) return correspondingDocument;
                repositoryAdapter = repository.createRepositoryAdapter();
                repositoryAdapter.openReadOnlyContext();
                EList contents = repositoryAdapter.getResource("/INTENT/IntentDocument").getContents();
                if (contents.isEmpty() || !(contents.iterator().next() instanceof IntentDocument)) return correspondingDocument;
                correspondingDocument = (IntentDocument)contents.iterator().next();
                return correspondingDocument;
            }
            catch (RepositoryConnectionException repositoryConnectionException) {
                if (repositoryAdapter == null) return correspondingDocument;
                repositoryAdapter.closeContext();
                return correspondingDocument;
            }
            catch (CoreException coreException) {
                if (repositoryAdapter == null) return correspondingDocument;
                repositoryAdapter.closeContext();
                return correspondingDocument;
            }
        }
        finally {
            if (repositoryAdapter != null) {
                repositoryAdapter.closeContext();
            }
        }
    }

    private static Collection<? extends Object> getSelectedObjects(Object receiver) {
        LinkedHashSet selectedObjects = Sets.newLinkedHashSet();
        if (receiver instanceof Collection) {
            selectedObjects.addAll((Collection)receiver);
        } else if (receiver instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)receiver).iterator();
            while (iterator.hasNext()) {
                selectedObjects.add(iterator);
            }
        } else {
            selectedObjects.add(receiver);
        }
        return selectedObjects;
    }

    public static boolean isIntentProject(Object receiver) {
        for (Class interf : Lists.newArrayList((Object[])receiver.getClass().getInterfaces())) {
            if (!interf.getName().contains("IProject")) continue;
            try {
                return (Boolean)receiver.getClass().getMethod("hasNature", String.class).invoke(receiver, "org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature");
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static String getIntentProjectName(Object project) {
        try {
            return (String)project.getClass().getMethod("getName", new Class[0]).invoke(project, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

