/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotationMessageType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class IntentAnnotationImageProvider
implements IAnnotationImageProvider {
    private static final String ANNOTATION_IMAGE_FOLDER_PATH = "icon/annotation/";
    private static final String DEFAULT_IMAGE_PATH = "icon/annotation/compiler-info.gif";
    private Map<IntentAnnotationMessageType, String> annotationTypeToImagePath = new HashMap<IntentAnnotationMessageType, String>();

    public IntentAnnotationImageProvider() {
        this.annotationTypeToImagePath.put(IntentAnnotationMessageType.COMPILER_ERROR, "icon/annotation/compiler-error.gif");
        this.annotationTypeToImagePath.put(IntentAnnotationMessageType.COMPILER_WARNING, "icon/annotation/compiler-warning.gif");
        this.annotationTypeToImagePath.put(IntentAnnotationMessageType.COMPILER_INFO, DEFAULT_IMAGE_PATH);
        this.annotationTypeToImagePath.put(IntentAnnotationMessageType.PARSER_ERROR, "icon/annotation/syntaxerror.gif");
        this.annotationTypeToImagePath.put(IntentAnnotationMessageType.SYNC_WARNING, "icon/annotation/sync-warning.gif");
    }

    public Image getManagedImage(Annotation annotation) {
        String imagePath = DEFAULT_IMAGE_PATH;
        if (annotation instanceof IntentAnnotation) {
            imagePath = this.annotationTypeToImagePath.get((Object)((IntentAnnotation)annotation).getMessageType());
        }
        return IntentEditorActivator.getDefault().getImage(imagePath);
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String imageDescritporId) {
        return null;
    }
}

