/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.logger;

import org.eclipse.mylyn.docs.intent.collab.common.internal.logger.IntentLoggerRegistry;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;

public final class IntentLogger
implements IIntentLogger {
    private static IntentLogger INSTANCE;

    private IntentLogger() {
    }

    public static IntentLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IntentLogger();
        }
        return INSTANCE;
    }

    public void log(IIntentLogger.LogType logType, String message) {
        for (IIntentLogger logger : IntentLoggerRegistry.getDeclaredLoggers()) {
            logger.log(logType, message);
        }
    }

    public void log(IIntentLogger.LogType logType, String message, Throwable exception) {
        for (IIntentLogger logger : IntentLoggerRegistry.getDeclaredLoggers()) {
            logger.log(logType, message, exception);
        }
    }

    public void logError(Throwable throwable) {
        this.log(IIntentLogger.LogType.ERROR, throwable.getMessage(), throwable);
    }

    public void setDisplayLifecycleInformations(boolean shouldDisplayLifecycleInformations) {
        for (IIntentLogger logger : IntentLoggerRegistry.getDeclaredLoggers()) {
            logger.setDisplayLifecycleInformations(shouldDisplayLifecycleInformations);
        }
    }
}

