/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.configuration;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.swt.graphics.RGB;

public final class IntentColorConstants {
    private static final RGB DU_BACKGROUND;
    private static final RGB MU_BACKGROUND;
    private static final RGB MU_DECORATION_LINE_FOREGROUND;
    private static final RGB MU_DECORATION_BACKGROUND;
    private static final int MU_DECORATION_LINE_WIDTH = 2;

    static {
        MU_BACKGROUND = DU_BACKGROUND = new RGB(255, 255, 255);
        MU_DECORATION_LINE_FOREGROUND = new RGB(84, 84, 84);
        MU_DECORATION_BACKGROUND = new RGB(195, 195, 195);
    }

    private IntentColorConstants() {
    }

    public static RGB getDuBackground() {
        return DU_BACKGROUND;
    }

    public static RGB getDuDefaultForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_default_color");
    }

    public static RGB getDuKeywordForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_keyword_color");
    }

    public static RGB getDuTitleForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_title_color");
    }

    public static RGB getDUListForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_list_color");
    }

    public static RGB getMuDefaultForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.mu_default_color");
    }

    public static RGB getMuKeywordForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.mu_keyword_color");
    }

    public static RGB getMuStringForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.string_color");
    }

    public static RGB getCodeForeground() {
        return IntentColorConstants.getRGBFromPreferences("org.eclipse.mylyn.docs.intent.client.ui.preferences.code");
    }

    public static RGB getMuBackground() {
        return MU_BACKGROUND;
    }

    public static RGB getMuDecorationBackground() {
        return MU_DECORATION_BACKGROUND;
    }

    public static RGB getMuDecorationLineForeground() {
        return MU_DECORATION_LINE_FOREGROUND;
    }

    public static int getMuDecorationLineWidth() {
        return 2;
    }

    private static RGB getRGBFromPreferences(String preferenceKey) {
        return PreferenceConverter.getColor((IPreferenceStore)IntentEditorActivator.getDefault().getPreferenceStore(), (String)preferenceKey);
    }
}

