/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.builder;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.ide.builder.IntentBuilderDeltaVisitor;
import org.eclipse.mylyn.docs.intent.client.ui.ide.projectmanager.IntentProjectManager;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class IntentProjectListener
implements IResourceChangeListener {
    private Map<String, IntentProjectManager> projectManagers = new HashMap<String, IntentProjectManager>();

    public IntentProjectListener() {
        this.treatExistingIntentProjects();
    }

    public void treatExistingIntentProjects() {
        IProject[] allProjects;
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    this.handleOpenedProject(project);
                }
            }
            catch (CoreException e) {
                IntentUiLogger.logError((Throwable)e);
                try {
                    project.close((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    IntentUiLogger.logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta;
        if (event.getType() == 2 || event.getType() == 4) {
            IResource resource = event.getResource();
            try {
                if (resource instanceof IProject && resource.isAccessible() && ((IProject)resource).hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    this.handleClosedProject((IProject)resource);
                }
            }
            catch (CoreException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        } else if (event.getType() == 1 && (rootDelta = event.getDelta()) != null) {
            this.analyseWorkspaceDelta(rootDelta);
        }
    }

    protected void analyseWorkspaceDelta(IResourceDelta repositoryDelta) {
        try {
            IntentBuilderDeltaVisitor visitor = new IntentBuilderDeltaVisitor();
            repositoryDelta.accept((IResourceDeltaVisitor)visitor);
            for (IProject project : visitor.getOpenedProjects()) {
                this.handleOpenedProject(project);
            }
            for (IProject project : visitor.getClosedProjects()) {
                this.handleClosedProject(project);
            }
        }
        catch (CoreException e) {
            IntentUiLogger.logError((Throwable)e);
        }
    }

    public void handleOpenedProject(IProject project) {
        IntentProjectManager projectManager = this.getIntentProjectManager(project);
        try {
            IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[IntentProjectListener] Handling project " + project.getName());
            projectManager.connect();
            this.projectManagers.put(project.getName(), projectManager);
        }
        catch (RepositoryConnectionException e) {
            IntentUiLogger.logError((Throwable)e);
        }
    }

    public void handleClosedProject(IProject project) {
        IWorkbenchPage activePage;
        IntentProjectManager projectManager = this.getIntentProjectManager(project);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null && PlatformUI.getWorkbench().getWorkbenchWindowCount() == 1) {
            activeWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            final LinkedHashSet activeEditorsToClose = Sets.newLinkedHashSet();
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference activeEditor = iEditorReferenceArray[n2];
                try {
                    if (activeEditor.getEditorInput() instanceof IntentEditorInput && project.getName().equals(((IntentEditorInput)activeEditor.getEditorInput()).getRepository().getIdentifier())) {
                        activeEditorsToClose.add(activeEditor);
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    activePage.closeEditors(activeEditorsToClose.toArray(new IEditorReference[activeEditorsToClose.size()]), false);
                }
            });
        }
        if (projectManager != null) {
            try {
                projectManager.disconnect();
                this.projectManagers.remove(project.getName());
            }
            catch (RepositoryConnectionException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
    }

    private IntentProjectManager getIntentProjectManager(IProject project) {
        IntentProjectManager projectManager = this.projectManagers.get(project.getName());
        if (projectManager == null) {
            projectManager = new IntentProjectManager(project);
        }
        return projectManager;
    }
}

