/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentElementSerializer;

public final class IntentChapterSerializer {
    private IntentChapterSerializer() {
    }

    public static String serialize(IntentChapter chapter, IntentElementSerializer serializer) {
        StringBuilder renderedForm = new StringBuilder();
        renderedForm.append(serializer.tabulation());
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() + 1);
        int initalOffset = serializer.getCurrentOffset();
        renderedForm.append("Chapter");
        int initialLength = renderedForm.length();
        renderedForm.append(" ");
        if (chapter.getTitle() != null) {
            DescriptionUnitSerializer descriptionUnitSerializer = new DescriptionUnitSerializer();
            renderedForm.append(descriptionUnitSerializer.serializeSectionTitle((EObject)chapter.getTitle(), initalOffset + renderedForm.length()));
            serializer.getPositionManager().addIntentPositionManagerInformations(descriptionUnitSerializer.getPositionManager());
            renderedForm.append(" ");
        }
        renderedForm.append("{");
        for (EObject content : chapter.getIntentContent()) {
            if (content instanceof IntentSection) {
                renderedForm.append("\n");
            }
            serializer.setCurrentOffset(initalOffset + renderedForm.length());
            renderedForm.append(serializer.serialize(content));
        }
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() - 1);
        renderedForm.append(String.valueOf(serializer.tabulation()) + "}" + "\n");
        serializer.setCurrentOffset(initalOffset + renderedForm.length());
        serializer.setPositionForElement((EObject)chapter, initalOffset, renderedForm.length(), initialLength);
        return renderedForm.toString();
    }
}

