/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidReferenceException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageNotFoundResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageRegistrationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitLinkResolver {
    private EPackage.Registry packageRegistry;
    private IntentCompilerInformationHolder informationHolder;

    public ModelingUnitLinkResolver(EPackage.Registry packageRegistry, IntentCompilerInformationHolder informationHolder) {
        this.packageRegistry = packageRegistry;
        this.informationHolder = informationHolder;
    }

    public EStructuralFeature resolveEStructuralFeature(StructuralFeatureAffectation affectation, EClass eClass) throws ResolveException {
        String featureHRef = affectation.getName();
        try {
            EStructuralFeature foundFeature = eClass.getEStructuralFeature(featureHRef);
            if (foundFeature != null) {
                return foundFeature;
            }
        }
        catch (NullPointerException nullPointerException) {}
        throw new ResolveException((UnitInstruction)affectation, "The feature " + featureHRef + " doesn't exists in " + eClass.getName());
    }

    public EClassifier resolveEClassifierUsingPackageRegistry(UnitInstruction instruction, String href) throws ResolveException {
        ArrayList<EPackage> packageToInspect = new ArrayList<EPackage>();
        for (String packageURI : this.packageRegistry.keySet()) {
            packageToInspect.add(this.packageRegistry.getEPackage(packageURI));
        }
        EClassifier resolvedClassifier = null;
        for (EPackage ePackage : packageToInspect) {
            try {
                resolvedClassifier = this.resolveEClassifierUsingPackage(instruction, ePackage.getNsURI(), href);
            }
            catch (PackageNotFoundResolveException packageNotFoundResolveException) {}
            if (resolvedClassifier != null) break;
        }
        if (resolvedClassifier == null) {
            throw new ResolveException(instruction, "The Entity " + href + " cannot be resolved");
        }
        return resolvedClassifier;
    }

    public EClassifier resolveEClassifierUsingPackage(UnitInstruction instruction, List<String> packageURIs, String href) throws ResolveException, PackageNotFoundResolveException {
        EClassifier resolvedClass = null;
        for (String nsURI : packageURIs) {
            resolvedClass = this.resolveEClassifierUsingPackage(instruction, nsURI, href);
            if (resolvedClass != null) break;
        }
        if (resolvedClass == null) {
            throw new ResolveException(instruction, "The Entity " + href + " cannot be resolved");
        }
        return resolvedClass;
    }

    private EClassifier resolveEClassifierUsingPackage(UnitInstruction instruction, String nsURI, String href) throws PackageNotFoundResolveException {
        EPackage ePackage = this.packageRegistry.getEPackage(nsURI);
        if (ePackage == null) {
            throw new PackageNotFoundResolveException(instruction, "The package with nsURI \"" + nsURI + "\" cannot be found. ");
        }
        String classifierName = href;
        if (href.contains(".")) {
            classifierName = href.substring(href.lastIndexOf(46) + 1);
            String packageQualifiedName = href.substring(0, href.lastIndexOf(46));
            if (!this.getQualifiedName(ePackage).equals(packageQualifiedName)) {
                return null;
            }
        }
        EClassifier resolvedClass = null;
        EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
        if (foundClassifier != null) {
            resolvedClass = foundClassifier;
            if (instruction instanceof ReferenceValueForStructuralFeature) {
                ((ReferenceValueForStructuralFeature)instruction).setReferencedMetaType((EObject)resolvedClass);
            }
        }
        return resolvedClass;
    }

    private String getQualifiedName(EPackage ePackage) {
        String res = ePackage.getName();
        EPackage tmp = (EPackage)ePackage.eContainer();
        while (tmp != null) {
            res = String.valueOf(tmp.getName()) + '.' + res;
            tmp = (EPackage)tmp.eContainer();
        }
        return res;
    }

    public EObject resolveReferenceInElementList(UnitInstruction instruction, EClassifier searchedType, String referencedValue) throws InvalidReferenceException {
        EObject foundReference = (EObject)this.informationHolder.getCreatedInstanceByName(searchedType, referencedValue);
        if (foundReference == null) {
            throw new InvalidReferenceException(instruction, "The reference " + referencedValue + " cannot be resolved. ");
        }
        UnitInstruction instanciationInstruction = this.informationHolder.getInstanciationInstructionByCreatedElement(foundReference);
        if (instanciationInstruction instanceof ModelingUnitInstruction && instruction instanceof ContributionInstruction) {
            ((ContributionInstruction)instruction).getReferencedElement().setReferencedElement((ModelingUnitInstruction)instanciationInstruction);
        } else if (instanciationInstruction instanceof InstanciationInstruction && instruction instanceof ReferenceValueForStructuralFeature) {
            ((ReferenceValueForStructuralFeature)instruction).getReferencedElement().setReferencedElement((InstanciationInstruction)instanciationInstruction);
            ((ReferenceValueForStructuralFeature)instruction).setReferencedMetaType((EObject)((InstanciationInstruction)instanciationInstruction).getMetaType().getResolvedType());
        }
        return foundReference;
    }

    public void registerInPackageRegistry(UnitInstruction instruction, EPackage generatedPackage) {
        PackageRegistrationException exception = new PackageRegistrationException(instruction, "the generated package \"" + generatedPackage.getNsURI() + "\" cannot be registered (maybe because of an invalid connection to the repository)");
        if (this.packageRegistry == null) {
            throw exception;
        }
        this.packageRegistry.put((Object)generatedPackage.getNsURI(), (Object)generatedPackage);
    }
}

