/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.commands.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.commands.RoomOpeningHelper;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.etrice.ui.common.base.export.IBulkDiagramExporter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ExportDiagramsHandler
extends AbstractHandler {
    @Inject
    protected IResourceValidator resourceValidator;
    private IPreferenceStore store;

    public ExportDiagramsHandler() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
        this.store = UIBaseActivator.getDefault().getPreferenceStore();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor instanceof XtextEditor) {
            String fragment;
            IXtextDocument document;
            XtextEditor xtextEditor;
            IStructuredSelection ss;
            Object sel;
            final IPath path = ((FileEditorInput)editor.getEditorInput()).getPath();
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (sel = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof EObjectNode && this.checkPrerequisites(xtextEditor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event), document = xtextEditor.getDocument(), fragment = ((EObjectNode)sel).getEObjectURI().fragment())) {
                document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        EObject object;
                        if (resource != null && (object = resource.getEObject(fragment)) instanceof RoomModel) {
                            ExportDiagramsHandler.this.exportDiagrams((RoomModel)object, path, editor.getSite().getShell());
                        }
                    }
                });
            }
        }
        return null;
    }

    protected void exportDiagrams(RoomModel model, IPath modelPath, Shell shell) {
        IFolder folder;
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(modelPath.removeLastSegments(1));
        String relPath = this.store.getString("ExportDiagramPath");
        boolean projectRelative = "project".equals(this.store.getString("ExportDiagramPathRelativeTo"));
        if (projectRelative) {
            IProject project = container.getProject();
            folder = project.getFolder(relPath);
        } else {
            folder = container.getFolder((IPath)new Path(relPath));
        }
        if (folder != null) {
            if (!folder.exists()) {
                try {
                    this.create((IResource)folder);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (folder.exists()) {
                String folderPath = folder.getLocation().toOSString();
                IBulkDiagramExporter behaviorExporter = RoomOpeningHelper.getBehaviorDiagramAccess().getDiagramExporter();
                IBulkDiagramExporter structureExporter = RoomOpeningHelper.getStructureDiagramAccess().getDiagramExporter();
                model.getRoomClasses().forEach(rc -> {
                    if (rc instanceof ActorClass) {
                        ActorClass ac = (ActorClass)rc;
                        if (ac.getStateMachine() != null) {
                            behaviorExporter.export((EObject)ac, folderPath);
                        }
                        structureExporter.export((EObject)ac, folderPath);
                    } else if (rc instanceof SubSystemClass) {
                        structureExporter.export((EObject)((SubSystemClass)rc), folderPath);
                    }
                });
                try {
                    folder.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void create(IResource resource) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.create((IResource)resource.getParent());
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, null);
                break;
            }
            case 4: {
                ((IProject)resource).create(null);
                ((IProject)resource).open(null);
            }
        }
    }

    protected boolean checkPrerequisites(XtextEditor xtextEditor, IXtextDocument document, String fragment) {
        if (this.hasIssues(document, (IProgressMonitor)new NullProgressMonitor())) {
            MessageDialog.openError((Shell)xtextEditor.getSite().getShell(), (String)"Validation Errors", (String)"The editor has validation errors.\nCannot open diagram!");
            return false;
        }
        if (xtextEditor.isDirty() && !MessageDialog.openQuestion((Shell)xtextEditor.getSite().getShell(), (String)"Save model file", (String)"The editor will be saved before opening the diagram editor.\nProceed?")) {
            return false;
        }
        if (xtextEditor.isDirty()) {
            xtextEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }

    public boolean hasIssues(IXtextDocument xtextDocument, final IProgressMonitor monitor) {
        boolean issues = (Boolean)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                if (resource == null) {
                    return false;
                }
                List issueList = ExportDiagramsHandler.this.resourceValidator.validate((Resource)resource, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }
                });
                for (Issue issue : issueList) {
                    if (issue.getSeverity() != Severity.ERROR) continue;
                    return true;
                }
                return false;
            }
        });
        return issues;
    }

    public boolean isEnabled() {
        IStructuredSelection ss;
        Object sel;
        ISelection selection;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof ContentOutline && (selection = ((ContentOutline)part).getSelection()) instanceof IStructuredSelection && (sel = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof EObjectNode) {
            EObjectNode node = (EObjectNode)sel;
            String fragment = node.getEObjectURI().fragment();
            return fragment.equals("/");
        }
        return false;
    }
}

