/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard.deprecated;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.etrice.generator.ui.wizard.deprecated.RoomValidationHelper;
import org.eclipse.etrice.generator.ui.wizard.internal.IProjectPathProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class ModelCreationPage
extends WizardPage
implements Listener,
IProjectPathProvider {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    protected RoomValidationHelper roomValidator = RoomValidationHelper.createInstance();
    private ResourceAndContainerGroup resourceGroup;
    private IStructuredSelection selection;

    public ModelCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.resourceGroup = new ResourceAndContainerGroup(topLevel, (Listener)this, "Base name for new models:", "file", false, 250);
        this.initialPopulateContainerNameField();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    protected void initialPopulateContainerNameField() {
        Iterator it = this.selection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                }
            }
        }
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        if (valid) {
            String resourceName = this.resourceGroup.getResource();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus result = workspace.validateName(resourceName, 1);
            if (!result.isOK()) {
                this.setErrorMessage(result.getMessage());
                return false;
            }
            IPath folder = this.resourceGroup.getContainerFullPath();
            IPath file = folder.append(resourceName).addFileExtension("etmap");
            if (workspace.getRoot().exists(file)) {
                this.setErrorMessage("file '" + String.valueOf(file) + "' already exists in the workspace");
                return false;
            }
            file = folder.append(resourceName).addFileExtension("etphys");
            if (workspace.getRoot().exists(file)) {
                this.setErrorMessage("file '" + String.valueOf(file) + "' already exists in the workspace");
                return false;
            }
            file = folder.append(resourceName).addFileExtension("room");
            if (workspace.getRoot().exists(file)) {
                this.setErrorMessage("file '" + String.valueOf(file) + "' already exists in the workspace");
                return false;
            }
            if (!this.roomValidator.isValidFQN(this.getBaseName())) {
                this.setErrorMessage("Invalid roomModel name (" + this.roomValidator.getMessage() + ")");
                return false;
            }
        }
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        return valid;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    @Override
    public IPath getPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getBaseName() {
        return this.resourceGroup.getResource();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }
}

