/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptions;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        boolean first = true;
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String string = nr.getName();
                String string2 = string + "_";
                String string3 = ssi.getName();
                String clsname = string2 + string3;
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String string4 = this._cExtensions.sourceExtension();
                String file = clsname + "_Runner" + string4;
                this.fileIO.generateFile("generating Node runner file", path + file, this.generateSourceFile(root, ssi, first));
                first = false;
            }
        }
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssi, boolean first) {
        String string;
        StringConcatenation stringConcatenation;
        String string2;
        boolean bl;
        StringConcatenation stringConcatenation2 = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        String string3 = nr.getName();
        String string4 = string3 + "_";
        String string5 = ssi.getName();
        String clsname = string4 + string5;
        String string6 = null;
        String string7 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        boolean bl2 = bl = !Objects.equal((Object)string7, (Object)(string2 = (String)AbstractGeneratorOptions.MAIN_NAME.getDefaultValue()));
        if (bl) {
            String string8 = null;
            stringConcatenation = new StringConcatenation();
            stringConcatenation.append("The ");
            string = AbstractGeneratorOptions.MAIN_NAME.getName();
            stringConcatenation.append(string);
            stringConcatenation.append(" option is deprecated, use ET_MAIN_FUNCTION_NAME in etRuntimeConfig.h instead");
            this.logger.logWarning(stringConcatenation.toString());
            string6 = string8 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        } else {
            string6 = "ET_MAIN_FUNCTION_NAME";
        }
        String mainName = string6;
        stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* this class contains the main function running Node ");
        string = nr.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.append(" with SubSystem ");
        String string9 = ssi.getName();
        stringConcatenation.append(string9, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* it instantiates Node ");
        String string10 = nr.getName();
        stringConcatenation.append(string10, " ");
        stringConcatenation.append(" with SubSystem ");
        String string11 = ssi.getName();
        stringConcatenation.append(string11, " ");
        stringConcatenation.append(" and starts and ends the lifecycle");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include <string.h>");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string12 = this._cExtensions.getCHeaderFileName(nr, ssi);
        stringConcatenation.append(string12);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"debugging/etLogger.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"debugging/etDataLogger.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"osal/etPlatformLifecycle.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#ifndef ET_MAIN_FUNCTION_NAME");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("#define ET_MAIN_FUNCTION_NAME \tmain");
        stringConcatenation.newLine();
        stringConcatenation.append("#endif");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* eTrice main function");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* creates components and starts and stops the lifecycle");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("int ");
        stringConcatenation.append(mainName);
        stringConcatenation.append(" (");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#ifdef ET_DO_NOT_USE_ARGC_ARGV");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("void");
        stringConcatenation.newLine();
        stringConcatenation.append("#else");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("int argc, char** argv");
        stringConcatenation.newLine();
        stringConcatenation.append("#endif");
        stringConcatenation.newLine();
        stringConcatenation.append(") {");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#ifdef ET_DO_NOT_USE_ARGC_ARGV");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("int argc = 0;");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("char** argv = NULL;");
        stringConcatenation.newLine();
        stringConcatenation.append("#endif\t\t");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etUserEntry(); /* platform specific */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etLogger_logInfo(\"***   T H E   B E G I N   ***\");");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("ET_MSC_LOGGER_OPEN(\"main\");");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("ET_DATA_LOGGER_OPEN(\"main\");");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("/* startup sequence  of lifecycle */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append(clsname, "\t");
        stringConcatenation.append("_init(); \t\t/* lifecycle init */");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append(clsname, "\t");
        stringConcatenation.append("_start(); \t/* lifecycle start */");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etUserPreRun(); /* platform specific */");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("/* run Scheduler */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("int returnCode = ");
        stringConcatenation.append(clsname, "\t");
        stringConcatenation.append("_run(argc, argv);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etUserPostRun(); /* platform specific */");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("/* shutdown sequence of lifecycle */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append(clsname, "\t");
        stringConcatenation.append("_stop(); \t\t/* lifecycle stop */");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append(clsname, "\t");
        stringConcatenation.append("_destroy(); \t/* lifecycle destroy */");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("ET_MSC_LOGGER_CLOSE");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("ET_DATA_LOGGER_CLOSE");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etLogger_logInfo(\"***   T H E   E N D   ***\");");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("etUserExit(); /* platform specific */");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("return returnCode;");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation2 = stringConcatenation;
        return stringConcatenation2;
    }
}

