/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast;

import com.google.common.base.Objects;
import java.util.ArrayList;
import org.eclipse.etrice.dctools.fsm.ast.DCLanguage;
import org.eclipse.etrice.dctools.fsm.ast.DCScanner;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstArrayAccessNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstBracketNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstFeatureCallNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstIdentifierBracketNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstIdentifierNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstMatchNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstOperationCallNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstOtherNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstPeriodNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstWhitespaceNode;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCBracketToken;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCTextToken;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCToken;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class DCParser {
    private final DCScanner scanner;
    private String text;
    private ArrayList<DCTextToken> tokens;
    private int currentPosition = 0;

    public DCParser(DCLanguage language) {
        DCScanner dCScanner;
        this.scanner = dCScanner = new DCScanner(language);
    }

    public DCAstMatchNode parse(String text) {
        DCAstMatchNode dCAstMatchNode = null;
        this.text = text;
        this.tokens = this.scanner.scan(text);
        dCAstMatchNode = this.Match(null);
        return dCAstMatchNode;
    }

    private DCAstMatchNode Match(DCAstNode parent) {
        DCAstMatchNode mNode = new DCAstMatchNode(parent);
        boolean continue_ = true;
        while (continue_) {
            boolean bl;
            while (this.PartialMatch(mNode) != null) {
            }
            DCAstOtherNode dCAstOtherNode = this.Other(mNode);
            boolean bl2 = bl = dCAstOtherNode == null;
            if (!bl) continue;
            continue_ = false;
        }
        return mNode;
    }

    private DCAstOtherNode Other(DCAstNode parent) {
        DCAstOtherNode lastNode = null;
        DCTextToken token = this.read();
        if (token != null) {
            while (token != null) {
                DCAstOtherNode dCAstOtherNode;
                boolean bl = this.stopOther(token);
                if (bl) {
                    this.unread();
                    token = null;
                    continue;
                }
                int n = token.getBegin();
                int n2 = token.getLength();
                int n3 = n + n2;
                String string = this.text.substring(token.getBegin(), n3);
                lastNode = dCAstOtherNode = new DCAstOtherNode(parent, string, token);
                DCAstNode pNode = this.PartialMatch(null);
                if (pNode != null) {
                    this.unread(pNode);
                    token = null;
                    continue;
                }
                token = this.read();
            }
        }
        return lastNode;
    }

    private boolean stopOther(DCTextToken token) {
        DCToken dCToken = token.getToken();
        if (dCToken instanceof DCBracketToken) {
            return true;
        }
        DCToken.Kind kind = token.getToken().getKind();
        boolean bl = Objects.equal((Object)((Object)kind), (Object)((Object)DCToken.Kind.IDENTIFIER));
        return bl;
    }

    private DCAstNode PartialMatch(DCAstNode parent) {
        DCAstBracketNode dCAstBracketNode = this.ConcreteBracketExpression(parent);
        DCAstNode node = dCAstBracketNode;
        if (node == null) {
            node = this.FeatureCall(parent);
        }
        return node;
    }

    private DCAstBracketNode ConcreteBracketExpression(DCAstNode parent) {
        DCAstBracketNode node = this.RoundBracketExpression(parent);
        if (node == null) {
            node = this.CurlyBracketExpression(parent);
        }
        if (node == null) {
            node = this.SquareBracketExpression(parent);
        }
        return node;
    }

    private DCAstBracketNode RoundBracketExpression(DCAstNode parent) {
        return this.ConcreteBracketExpression(parent, DCBracketToken.BracketKind.LEFT_ROUND, DCBracketToken.BracketKind.RIGHT_ROUND, DCAstBracketNode.BracketType.ROUND);
    }

    private DCAstBracketNode CurlyBracketExpression(DCAstNode parent) {
        return this.ConcreteBracketExpression(parent, DCBracketToken.BracketKind.LEFT_CURLY, DCBracketToken.BracketKind.RIGHT_CURLY, DCAstBracketNode.BracketType.CURLY);
    }

    private DCAstBracketNode SquareBracketExpression(DCAstNode parent) {
        return this.ConcreteBracketExpression(parent, DCBracketToken.BracketKind.LEFT_SQUARE, DCBracketToken.BracketKind.RIGHT_SQUARE, DCAstBracketNode.BracketType.SQUARE);
    }

    private DCAstBracketNode ConcreteBracketExpression(DCAstNode parent, DCBracketToken.BracketKind left, DCBracketToken.BracketKind right, DCAstBracketNode.BracketType type) {
        DCTextToken token = this.read();
        if (token != null) {
            DCToken dCToken;
            DCBracketToken b;
            DCBracketToken.BracketKind bracketKind;
            boolean bl;
            DCToken dCToken2 = token.getToken();
            if (dCToken2 instanceof DCBracketToken && (bl = Objects.equal((Object)((Object)(bracketKind = (b = (DCBracketToken)(dCToken = token.getToken())).getBracketKind())), (Object)((Object)left)))) {
                DCAstMatchNode contents = this.Match(parent);
                int leftPos = token.getBegin();
                token = this.read();
                if (token != null) {
                    DCToken dCToken3 = token.getToken();
                    if (dCToken3 instanceof DCBracketToken) {
                        int rightPos = token.getBegin();
                        DCToken dCToken4 = token.getToken();
                        b = (DCBracketToken)dCToken4;
                        DCBracketToken.BracketKind bracketKind2 = b.getBracketKind();
                        boolean bl2 = Objects.equal((Object)((Object)bracketKind2), (Object)((Object)right));
                        if (bl2) {
                            return new DCAstBracketNode(parent, type, contents, leftPos, rightPos);
                        }
                    }
                } else {
                    return new DCAstBracketNode(parent, type, contents, leftPos);
                }
                this.unread();
                this.unread(contents);
            }
            this.unread();
        }
        return null;
    }

    private DCAstFeatureCallNode FeatureCall(DCAstNode parent) {
        DCAstNode callNode = this.Call(parent);
        if (callNode != null) {
            DCAstFeatureCallNode fcNode = new DCAstFeatureCallNode(parent);
            callNode.setParent(fcNode);
            this.Whitespace(fcNode);
            DCTextToken token = this.read();
            while (token != null) {
                DCToken.Kind kind = token.getToken().getKind();
                boolean bl = Objects.equal((Object)((Object)kind), (Object)((Object)DCToken.Kind.PERIOD));
                if (bl) {
                    int n = token.getBegin();
                    DCAstPeriodNode pNode = new DCAstPeriodNode(null, n);
                    DCAstWhitespaceNode wsNode = this.Whitespace(null);
                    DCAstNode cNode = this.Call(null);
                    DCAstWhitespaceNode wsNode2 = this.Whitespace(null);
                    if (pNode != null) {
                        pNode.setParent(fcNode);
                        if (wsNode != null) {
                            wsNode.setParent(fcNode);
                        }
                        if (cNode != null) {
                            cNode.setParent(fcNode);
                        }
                        if (wsNode2 != null) {
                            wsNode2.setParent(fcNode);
                        }
                        if (cNode != null) {
                            token = this.read();
                            continue;
                        }
                        token = null;
                        continue;
                    }
                    this.unread(pNode);
                    this.unread(wsNode);
                    this.unread(pNode);
                    this.unread(wsNode2);
                    this.unread();
                    token = null;
                    continue;
                }
                this.unread();
                token = null;
            }
            return fcNode;
        }
        this.unread(callNode);
        return null;
    }

    private DCAstNode Call(DCAstNode parent) {
        Object object;
        Functions.Function1<DCAstNode, DCAstBracketNode> function1 = new Functions.Function1<DCAstNode, DCAstBracketNode>(){

            public DCAstBracketNode apply(DCAstNode it) {
                return DCParser.this.SquareBracketExpression(it);
            }
        };
        Functions.Function4<DCAstNode, DCAstIdentifierNode, DCAstWhitespaceNode, DCAstBracketNode, DCAstIdentifierBracketNode> function4 = new Functions.Function4<DCAstNode, DCAstIdentifierNode, DCAstWhitespaceNode, DCAstBracketNode, DCAstIdentifierBracketNode>(){

            public DCAstIdentifierBracketNode apply(DCAstNode p, DCAstIdentifierNode i, DCAstWhitespaceNode w, DCAstBracketNode b) {
                return new DCAstArrayAccessNode(p, i, w, b);
            }
        };
        DCAstIdentifierBracketNode node = this.BracketExpressionCall(parent, (Functions.Function1<? super DCAstNode, ? extends DCAstBracketNode>)function1, (Functions.Function4<? super DCAstNode, ? super DCAstIdentifierNode, ? super DCAstWhitespaceNode, ? super DCAstBracketNode, ? extends DCAstIdentifierBracketNode>)function4);
        if (node == null) {
            Functions.Function1<DCAstNode, DCAstBracketNode> function12 = new Functions.Function1<DCAstNode, DCAstBracketNode>(){

                public DCAstBracketNode apply(DCAstNode it) {
                    return DCParser.this.RoundBracketExpression(it);
                }
            };
            object = new Functions.Function4<DCAstNode, DCAstIdentifierNode, DCAstWhitespaceNode, DCAstBracketNode, DCAstIdentifierBracketNode>(){

                public DCAstIdentifierBracketNode apply(DCAstNode p, DCAstIdentifierNode i, DCAstWhitespaceNode w, DCAstBracketNode b) {
                    return new DCAstOperationCallNode(p, i, w, b);
                }
            };
            node = this.BracketExpressionCall(parent, (Functions.Function1<? super DCAstNode, ? extends DCAstBracketNode>)function12, (Functions.Function4<? super DCAstNode, ? super DCAstIdentifierNode, ? super DCAstWhitespaceNode, ? super DCAstBracketNode, ? extends DCAstIdentifierBracketNode>)object);
        }
        if (node != null) {
            return node;
        }
        DCTextToken token = this.read();
        if (token != null) {
            object = token.getToken().getKind();
            boolean bl = Objects.equal((Object)object, (Object)((Object)DCToken.Kind.IDENTIFIER));
            if (bl) {
                int n = token.getBegin();
                int n2 = token.getLength();
                int n3 = n + n2;
                String id = this.text.substring(token.getBegin(), n3);
                return new DCAstIdentifierNode(parent, id, token);
            }
            this.unread();
        }
        return null;
    }

    private DCAstIdentifierBracketNode BracketExpressionCall(DCAstNode parent, Functions.Function1<? super DCAstNode, ? extends DCAstBracketNode> bracketExpression, Functions.Function4<? super DCAstNode, ? super DCAstIdentifierNode, ? super DCAstWhitespaceNode, ? super DCAstBracketNode, ? extends DCAstIdentifierBracketNode> factory) {
        DCTextToken token = this.read();
        if (token != null) {
            DCToken.Kind kind = token.getToken().getKind();
            boolean bl = Objects.equal((Object)((Object)kind), (Object)((Object)DCToken.Kind.IDENTIFIER));
            if (bl) {
                int n = token.getBegin();
                int n2 = token.getLength();
                int n3 = n + n2;
                String id = this.text.substring(token.getBegin(), n3);
                DCAstIdentifierNode idNode = new DCAstIdentifierNode(parent, id, token);
                DCAstWhitespaceNode wsNode = this.Whitespace(parent);
                DCAstBracketNode node = (DCAstBracketNode)bracketExpression.apply((Object)parent);
                if (node != null) {
                    DCAstIdentifierBracketNode callNode = (DCAstIdentifierBracketNode)factory.apply((Object)parent, (Object)idNode, (Object)wsNode, (Object)node);
                    return callNode;
                }
                this.unread(idNode);
                this.unread(wsNode);
            } else {
                this.unread();
            }
        }
        return null;
    }

    private DCAstWhitespaceNode Whitespace(DCAstNode parent) {
        DCTextToken token = this.read();
        int n = 0;
        n = token != null ? token.getBegin() : 0;
        int begin = n;
        int end = 0;
        int count = 0;
        while (token != null) {
            DCToken.Kind kind = token.getToken().getKind();
            boolean bl = Objects.equal((Object)((Object)kind), (Object)((Object)DCToken.Kind.WHITESPACE));
            if (bl) {
                int n2;
                int n3 = token.getBegin();
                int n4 = token.getLength();
                end = n2 = n3 + n4;
                ++count;
                token = this.read();
                continue;
            }
            token = null;
            this.unread();
        }
        if (count > 0) {
            String ws = this.text.substring(begin, end);
            return new DCAstWhitespaceNode(parent, count, begin, ws);
        }
        return null;
    }

    private DCTextToken read() {
        boolean bl;
        DCTextToken dCTextToken = null;
        int n = this.tokens.size();
        boolean bl2 = bl = this.currentPosition < n;
        if (bl) {
            int n2 = this.currentPosition++;
            dCTextToken = this.tokens.get(n2);
        } else {
            dCTextToken = null;
        }
        return dCTextToken;
    }

    private void unread() {
        this.unread(1);
    }

    private void unread(int i) {
        this.currentPosition -= i;
        if (this.currentPosition < 0) {
            InputOutput.println((Object)"oops");
        }
    }

    private void unread(DCAstNode node) {
        if (node != null) {
            node.setParent(null);
            this.unread(node.totallyReadTokens());
        }
    }
}

