/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.quickfix;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.etrice.core.ui.quickfix.IRoomQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class QuickfixExtensionManager {
    private static final String IQUICKFIX_ID = "org.eclipse.etrice.core.room.ui.quickfix";
    private static QuickfixExtensionManager instance = null;
    private HashMap<String, ArrayList<IRoomQuickfixProvider>> code2provider = new HashMap();

    public static QuickfixExtensionManager getInstance() {
        if (instance == null) {
            instance = new QuickfixExtensionManager();
        }
        return instance;
    }

    public void loadQuickfixExtensions() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(IQUICKFIX_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object ext = e.createExecutableExtension("class");
                if (ext instanceof IRoomQuickfixProvider) {
                    String code = e.getAttribute("code");
                    this.put(code, (IRoomQuickfixProvider)ext);
                } else {
                    System.out.println("QuickfixExtensionManager: unexpected extension");
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void getResolutions(Issue issue, IssueResolutionAcceptor acceptor) {
        ArrayList<IRoomQuickfixProvider> list = this.code2provider.get(issue.getCode());
        if (list != null) {
            for (IRoomQuickfixProvider provider : list) {
                this.executeExtension(provider, issue, acceptor);
            }
        }
    }

    public boolean hasResolutionFor(String issueCode) {
        ArrayList<IRoomQuickfixProvider> list = this.code2provider.get(issueCode);
        return list != null && !list.isEmpty();
    }

    private void executeExtension(final IRoomQuickfixProvider provider, final Issue issue, final IssueResolutionAcceptor acceptor) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                System.out.println("Exception in IRoomValidator");
            }

            public void run() throws Exception {
                provider.getResolution(issue, acceptor);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    private void put(String code, IRoomQuickfixProvider ext) {
        ArrayList<IRoomQuickfixProvider> list = this.code2provider.get(code);
        if (list == null) {
            list = new ArrayList();
            this.code2provider.put(code, list);
        }
        list.add(ext);
    }
}

