/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.relations.ciftodmm;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.relations.ciftodmm.Labels;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifRelations {
    public final Dmm plantGroups;
    public final Dmm requirementGroups;
    public final Dmm relations;

    public CifRelations(Dmm plantGroups, Dmm requirementGroups, Dmm relations) {
        this.plantGroups = plantGroups;
        this.requirementGroups = requirementGroups;
        this.relations = relations;
    }

    public Collection<PositionObject> getPlantsOfGroup(int grp) {
        return (Collection)this.plantGroups.getRowLabels(this.plantGroups.filterColumn(grp, v -> v != 0.0)).stream().map(Labels::unwrapLabel).collect(Lists.toList());
    }

    public Collection<String> getPlantNamesOfGroup(int grp) {
        return (Collection)this.plantGroups.getRowLabels(this.plantGroups.filterColumn(grp, v -> v != 0.0)).stream().map(Label::toString).collect(Lists.toList());
    }

    public List<String> getSortedPlantNames(BitSet plantGroups) {
        List plantNames = (List)plantGroups.stream().mapToObj(p -> this.getPlantNamesOfGroup(p)).flatMap(names -> names.stream()).distinct().collect(Lists.toList());
        Collections.sort(plantNames);
        return plantNames;
    }

    public Collection<PositionObject> getRequirementsOfGroup(int grp) {
        return (Collection)this.requirementGroups.getRowLabels(this.requirementGroups.filterColumn(grp, v -> v != 0.0)).stream().map(Labels::unwrapLabel).collect(Lists.toList());
    }

    public Collection<String> getRequirementNamesOfGroup(int grp) {
        return (Collection)this.requirementGroups.getRowLabels(this.requirementGroups.filterColumn(grp, v -> v != 0.0)).stream().map(Label::toString).collect(Lists.toList());
    }

    public List<String> getSortedRequirementNames(BitSet requirementGroups) {
        List requirementNames = (List)requirementGroups.stream().mapToObj(r -> this.getRequirementNamesOfGroup(r)).flatMap(names -> names.stream()).distinct().collect(Lists.toList());
        Collections.sort(requirementNames);
        return requirementNames;
    }

    public Collection<PositionObject> getUselessRequirements() {
        List uselessRequirements = Lists.list();
        int row = 0;
        while (row < this.relations.adjacencies.getRowDimension()) {
            int finalRow = row;
            boolean isUnrelated = IntStream.range(0, this.relations.adjacencies.getColumnDimension()).allMatch(col -> this.relations.adjacencies.getEntry(finalRow, col) == 0.0);
            if (isUnrelated) {
                uselessRequirements.addAll(this.getRequirementsOfGroup(row));
            }
            ++row;
        }
        return uselessRequirements;
    }

    public void writeDmms(String cifPath, String outPath) {
        String absOutPath = Paths.resolve((String)outPath);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileAppStream stream = new FileAppStream(outPath, absOutPath);){
            stream.printfln("DMMs of the \"%s\" CIF specification.", new Object[]{cifPath});
            stream.println();
            stream.printfln("Plant groups:%n%s", new Object[]{this.plantGroups.toString()});
            stream.println();
            stream.printfln("Requirement groups:%n%s", new Object[]{this.requirementGroups.toString()});
            stream.println();
            stream.printfln("Plant-groups/requirement-groups relations:%n%s", new Object[]{this.relations.toString()});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

