/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser;

import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.parser.SeTextParser;
import org.eclipse.escet.setext.parser.SeTextScanner;
import org.eclipse.escet.setext.parser.ast.Decl;
import org.eclipse.escet.setext.parser.ast.HooksDecl;
import org.eclipse.escet.setext.parser.ast.Identifier;
import org.eclipse.escet.setext.parser.ast.Name;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.TerminalDescription;
import org.eclipse.escet.setext.parser.ast.parser.ImportDecl;
import org.eclipse.escet.setext.parser.ast.parser.JavaType;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExAlts;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharClass;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExChars;
import org.eclipse.escet.setext.parser.ast.regex.RegExDot;
import org.eclipse.escet.setext.parser.ast.regex.RegExOpt;
import org.eclipse.escet.setext.parser.ast.regex.RegExPlus;
import org.eclipse.escet.setext.parser.ast.regex.RegExSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExShortcut;
import org.eclipse.escet.setext.parser.ast.regex.RegExStar;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsIdentifier;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsTerminal;
import org.eclipse.escet.setext.parser.ast.scanner.ScannerDecl;
import org.eclipse.escet.setext.parser.ast.scanner.ShortcutDecl;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.parser.ast.scanner.TerminalsDecl;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.Token;

public final class SeTextHooks
implements SeTextScanner.Hooks,
SeTextParser.Hooks {
    private Parser<?> parser;

    public void setParser(Parser<?> parser) {
        this.parser = parser;
    }

    @Override
    public void scanRegExEscapedChar(Token token) {
        Assert.check((token.text.length() == 2 ? 1 : 0) != 0);
        Assert.check((token.text.charAt(0) == '\\' ? 1 : 0) != 0);
        char c = token.text.charAt(1);
        switch (c) {
            case 'n': {
                c = '\n';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'r': {
                c = '\r';
            }
        }
        token.text = Character.toString(c);
    }

    @Override
    public void scanRegExShortcutName(Token token) {
        Assert.check((boolean)token.text.startsWith("{"));
        Assert.check((boolean)token.text.endsWith("}"));
        token.text = Strings.slice((String)token.text, (Integer)1, (Integer)-1);
    }

    @Override
    public Specification parseSpecification1() {
        List decls = Lists.list();
        String src = this.parser.getSource();
        String loc = this.parser.getLocation();
        return new Specification(decls, TextPosition.createDummy((String)loc, (String)src));
    }

    @Override
    public Specification parseSpecification2(List<Decl> l1) {
        String src = this.parser.getSource();
        String loc = this.parser.getLocation();
        return new Specification(l1, TextPosition.createDummy((String)loc, (String)src));
    }

    @Override
    public List<Decl> parseDecls1(Decl d1) {
        return Lists.list((Object)d1);
    }

    @Override
    public List<Decl> parseDecls2(List<Decl> l1, Decl d2) {
        l1.add(d2);
        return l1;
    }

    @Override
    public Decl parseDecl1(TerminalsDecl t1) {
        return t1;
    }

    @Override
    public Decl parseDecl2(ShortcutDecl s1) {
        return s1;
    }

    @Override
    public Decl parseDecl3(StartSymbol s1) {
        return s1;
    }

    @Override
    public Decl parseDecl4(StartSymbol s1) {
        return s1;
    }

    @Override
    public Decl parseDecl5(HooksDecl h1) {
        return h1;
    }

    @Override
    public Decl parseDecl6(ScannerDecl s1) {
        return s1;
    }

    @Override
    public Decl parseDecl7(ImportDecl i1) {
        return i1;
    }

    @Override
    public Decl parseDecl8(NonTerminal n1) {
        return n1;
    }

    @Override
    public TerminalsDecl parseTerminalsDecl1(Token t1, Token t2, Identifier i3, List<Symbol> l5, Token t6) {
        this.parser.addFoldRange(t1, t6);
        return new TerminalsDecl(i3, l5, i3 == null ? t2.position : i3.position);
    }

    @Override
    public List<Symbol> parseTerminals1(Symbol s1) {
        return Lists.list((Object)s1);
    }

    @Override
    public List<Symbol> parseTerminals2(List<Symbol> l1, Symbol s2) {
        l1.add(s2);
        return l1;
    }

    @Override
    public Symbol parseTerminal1(KeywordsTerminal k1) {
        return k1;
    }

    @Override
    public Symbol parseTerminal2(Terminal t1) {
        return t1;
    }

    @Override
    public Symbol parseTerminal3(Token t2) {
        return new Terminal(null, new RegExChar(-1, t2.position), null, null, null, t2.position);
    }

    @Override
    public KeywordsTerminal parseKeywordsTerminal1(Token t1, Identifier i3, List<KeywordsIdentifier> l5, Token t6) {
        this.parser.addFoldRange(t1, t6);
        return new KeywordsTerminal(i3.id, l5, i3.position);
    }

    @Override
    public List<KeywordsIdentifier> parseKeywordsIdentifiers1(Identifier i1, Identifier i2, TerminalDescription t3) {
        return Lists.list((Object)new KeywordsIdentifier(i1, i2, t3, i1.position));
    }

    @Override
    public List<KeywordsIdentifier> parseKeywordsIdentifiers2(List<KeywordsIdentifier> l1, Identifier i2, Identifier i3, TerminalDescription t4) {
        l1.add(new KeywordsIdentifier(i2, i3, t4, i2.position));
        return l1;
    }

    @Override
    public Terminal parseRegExTerminal1(Identifier i1, RegEx r2, Identifier i3, Identifier i4, TerminalDescription t5) {
        TextPosition p = i1 != null ? i1.position : r2.position;
        String name = i1 != null ? i1.id : null;
        return new Terminal(name, r2, i3, i4, t5, p);
    }

    @Override
    public Identifier parseOptRegExId1() {
        return null;
    }

    @Override
    public Identifier parseOptRegExId2(Identifier i1) {
        return i1;
    }

    @Override
    public Identifier parseIdentifier1(Token t1) {
        return new Identifier(t1.text, t1.position);
    }

    @Override
    public TerminalDescription parseOptTermDescr1() {
        return null;
    }

    @Override
    public TerminalDescription parseOptTermDescr2(Token t1) {
        return new TerminalDescription(t1.text, t1.position);
    }

    @Override
    public Identifier parseOptFunc1() {
        return null;
    }

    @Override
    public Identifier parseOptFunc2(Identifier i2) {
        return i2;
    }

    @Override
    public Identifier parseOptNewState1() {
        return null;
    }

    @Override
    public Identifier parseOptNewState2(Token t1) {
        return new Identifier("", t1.position);
    }

    @Override
    public Identifier parseOptNewState3(Identifier i2) {
        return i2;
    }

    @Override
    public ShortcutDecl parseShortcutDecl1(Identifier i3, RegEx r5) {
        return new ShortcutDecl(i3.id, r5, i3.position);
    }

    @Override
    public StartSymbol parseMainDecl1(Identifier i3, JavaType j5) {
        return new StartSymbol(true, i3, j5, i3.position);
    }

    @Override
    public StartSymbol parseStartDecl1(Identifier i3, JavaType j5) {
        return new StartSymbol(false, i3, j5, i3.position);
    }

    @Override
    public HooksDecl parseHooksDecl1(JavaType j3) {
        return new HooksDecl(j3, j3.position);
    }

    @Override
    public ScannerDecl parseScannerDecl1(JavaType j3) {
        return new ScannerDecl(j3, j3.position);
    }

    @Override
    public ImportDecl parseImportDecl1(JavaType j3) {
        return new ImportDecl(j3, null, j3.position);
    }

    @Override
    public ImportDecl parseImportDecl2(JavaType j3, Identifier i5) {
        return new ImportDecl(j3, i5.id, i5.position);
    }

    @Override
    public NonTerminal parseRuleDecl1(JavaType j2, Identifier i4, List<ParserRule> l6, Token t7) {
        this.parser.addFoldRange(i4.position, t7.position);
        return new NonTerminal(j2, i4.id, l6, false, i4.position);
    }

    @Override
    public List<ParserRule> parseRuleAlts1() {
        List parts = Lists.list();
        return Lists.list((Object)new ParserRule(parts));
    }

    @Override
    public List<ParserRule> parseRuleAlts2(ParserRule p1) {
        return Lists.list((Object)p1);
    }

    @Override
    public List<ParserRule> parseRuleAlts3(List<ParserRule> l1, ParserRule p3) {
        l1.add(p3);
        return l1;
    }

    @Override
    public ParserRule parseRuleAlt1(Identifier i1) {
        List parts = Lists.list();
        parts.add(new ParserRulePart(i1.id, false, i1.position));
        return new ParserRule(parts);
    }

    @Override
    public ParserRule parseRuleAlt2(Identifier i2) {
        List parts = Lists.list();
        parts.add(new ParserRulePart(i2.id, true, i2.position));
        return new ParserRule(parts);
    }

    @Override
    public ParserRule parseRuleAlt3(ParserRule p1, Identifier i2) {
        List symbols = Lists.list();
        symbols.addAll(p1.symbols);
        symbols.add(new ParserRulePart(i2.id, false, i2.position));
        return new ParserRule(symbols);
    }

    @Override
    public ParserRule parseRuleAlt4(ParserRule p1, Identifier i3) {
        List symbols = Lists.list();
        symbols.addAll(p1.symbols);
        symbols.add(new ParserRulePart(i3.id, true, i3.position));
        return new ParserRule(symbols);
    }

    @Override
    public List<JavaType> parseJavaTypes1(JavaType j1) {
        return Lists.list((Object)j1);
    }

    @Override
    public List<JavaType> parseJavaTypes2(List<JavaType> l1, JavaType j3) {
        l1.add(j3);
        return l1;
    }

    @Override
    public JavaType parseJavaType1(Identifier i1) {
        return new JavaType(i1.id, null, i1.position);
    }

    @Override
    public JavaType parseJavaType2(Identifier i1, List<JavaType> l3) {
        return new JavaType(i1.id, l3, i1.position);
    }

    @Override
    public JavaType parseJavaType3(Name n1) {
        return new JavaType(n1.name, null, n1.position);
    }

    @Override
    public JavaType parseJavaType4(Name n1, List<JavaType> l3) {
        return new JavaType(n1.name, l3, n1.position);
    }

    @Override
    public Name parseName1(Token t1) {
        return new Name(t1.text, t1.position);
    }

    @Override
    public Identifier parseOptIdentifier1() {
        return null;
    }

    @Override
    public Identifier parseOptIdentifier2(Identifier i1) {
        return i1;
    }

    @Override
    public RegEx parseRegExString1(Token t1, RegEx r2, Token t3) {
        if (r2.position == null) {
            r2.position = TextPosition.mergePositions((TextPosition)t1.position, (TextPosition)t3.position);
        }
        return r2;
    }

    @Override
    public RegEx parseRegEx1(RegEx r1) {
        return r1;
    }

    @Override
    public RegEx parseRegEx2(RegEx r1, RegEx r3) {
        List alts = Lists.list();
        if (r1 instanceof RegExAlts) {
            alts.addAll(((RegExAlts)r1).alts);
        } else {
            alts.add(r1);
        }
        if (r3 instanceof RegExAlts) {
            alts.addAll(((RegExAlts)r3).alts);
        } else {
            alts.add(r3);
        }
        return new RegExAlts(alts);
    }

    @Override
    public RegEx parseRegExBranch1(RegEx r1) {
        return r1;
    }

    @Override
    public RegEx parseRegExBranch2(RegEx r1, RegEx r2) {
        List seq = Lists.list();
        if (r1 instanceof RegExSeq) {
            seq.addAll(((RegExSeq)r1).sequence);
        } else {
            seq.add(r1);
        }
        if (r2 instanceof RegExSeq) {
            seq.addAll(((RegExSeq)r2).sequence);
        } else {
            seq.add(r2);
        }
        return new RegExSeq(seq);
    }

    @Override
    public RegEx parseRegExPiece1(RegEx r1) {
        return r1;
    }

    @Override
    public RegEx parseRegExPiece2(RegEx r1, Token t2) {
        return new RegExStar(r1, t2.position);
    }

    @Override
    public RegEx parseRegExPiece3(RegEx r1, Token t2) {
        return new RegExPlus(r1, t2.position);
    }

    @Override
    public RegEx parseRegExPiece4(RegEx r1, Token t2) {
        return new RegExOpt(r1, t2.position);
    }

    @Override
    public RegEx parseRegExAtom1(RegEx r2) {
        return r2;
    }

    @Override
    public RegEx parseRegExAtom2(Token t1) {
        return new RegExShortcut(t1.text, t1.position);
    }

    @Override
    public RegEx parseRegExAtom3(RegEx r1) {
        return r1;
    }

    @Override
    public RegEx parseRegExAtom4(RegExChar r1) {
        return r1;
    }

    @Override
    public RegEx parseRegExAtom5(Token t1) {
        return new RegExDot(t1.position);
    }

    @Override
    public RegEx parseRegExCharClass1(Token t1, List<RegExChars> l2) {
        return new RegExCharClass(false, l2, t1.position);
    }

    @Override
    public RegEx parseRegExCharClass2(Token t1, List<RegExChars> l3) {
        return new RegExCharClass(true, l3, t1.position);
    }

    @Override
    public List<RegExChars> parseRegExCharsList1(RegExChars r1) {
        return Lists.list((Object)r1);
    }

    @Override
    public List<RegExChars> parseRegExCharsList2(List<RegExChars> l1, RegExChars r2) {
        l1.add(r2);
        return l1;
    }

    @Override
    public RegExChars parseRegExChars1(RegExChar r1) {
        return r1;
    }

    @Override
    public RegExChars parseRegExChars2(RegExChar r1, Token t2, RegExChar r3) {
        return new RegExCharSeq(r1, r3, t2.position);
    }

    @Override
    public RegExChar parseRegExChar1(Token t1) {
        Assert.check((t1.text.length() == 1 ? 1 : 0) != 0);
        return new RegExChar(t1.text.charAt(0), t1.position);
    }

    @Override
    public RegExChar parseRegExChar2(Token t1) {
        Assert.check((t1.text.length() == 1 ? 1 : 0) != 0);
        return new RegExChar(t1.text.charAt(0), t1.position);
    }
}

