/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Set;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Sets;

public class ConstantOrderer
extends DependencyOrderer<Constant> {
    protected Set<Constant> findDirectDependencies(Constant constant) {
        Set rslt = Sets.set();
        ConstantOrderer.collectConstants(constant.getValue(), rslt);
        return rslt;
    }

    private static void collectConstants(Expression expr, Set<Constant> constants) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof CastExpression) {
            ConstantOrderer.collectConstants(((CastExpression)expr).getChild(), constants);
            return;
        }
        if (expr instanceof UnaryExpression) {
            ConstantOrderer.collectConstants(((UnaryExpression)expr).getChild(), constants);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            ConstantOrderer.collectConstants(bexpr.getLeft(), constants);
            ConstantOrderer.collectConstants(bexpr.getRight(), constants);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression iexpr = (IfExpression)expr;
            for (Expression guard : iexpr.getGuards()) {
                ConstantOrderer.collectConstants(guard, constants);
            }
            ConstantOrderer.collectConstants(iexpr.getThen(), constants);
            for (ElifExpression elif : iexpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    ConstantOrderer.collectConstants(guard, constants);
                }
                ConstantOrderer.collectConstants(elif.getThen(), constants);
            }
            ConstantOrderer.collectConstants(iexpr.getElse(), constants);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sexpr = (SwitchExpression)expr;
            ConstantOrderer.collectConstants(sexpr.getValue(), constants);
            for (SwitchCase cse : sexpr.getCases()) {
                if (cse.getKey() != null) {
                    ConstantOrderer.collectConstants(cse.getKey(), constants);
                }
                ConstantOrderer.collectConstants(cse.getValue(), constants);
            }
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            ConstantOrderer.collectConstants(pexpr.getChild(), constants);
            ConstantOrderer.collectConstants(pexpr.getIndex(), constants);
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            ConstantOrderer.collectConstants(sexpr.getChild(), constants);
            if (sexpr.getBegin() != null) {
                ConstantOrderer.collectConstants(sexpr.getBegin(), constants);
            }
            if (sexpr.getEnd() != null) {
                ConstantOrderer.collectConstants(sexpr.getEnd(), constants);
            }
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            for (Expression arg : fexpr.getArguments()) {
                ConstantOrderer.collectConstants(arg, constants);
            }
            ConstantOrderer.collectConstants(fexpr.getFunction(), constants);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                ConstantOrderer.collectConstants(elem, constants);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                ConstantOrderer.collectConstants(elem, constants);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                ConstantOrderer.collectConstants(field, constants);
            }
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                ConstantOrderer.collectConstants(pair.getKey(), constants);
                ConstantOrderer.collectConstants(pair.getValue(), constants);
            }
            return;
        }
        if (expr instanceof ConstantExpression) {
            constants.add(((ConstantExpression)expr).getConstant());
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            return;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }
}

