/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.data.IContent;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
extends Element
implements IContent {
    public static final ElementKey<String, Content> CONSTRUCT = ElementKey.of(null, String.class, Content.class);
    public static final ElementKey<String, Content> KEY = ElementKey.of(new QName(Namespaces.atomNs, "content"), String.class, Content.class);
    public static final AttributeKey<String> XML_LANG = AttributeKey.of(new QName(Namespaces.xmlNs, "lang"));
    public static final AttributeKey<String> TYPE = AttributeKey.of(new QName("type"));
    public static final AttributeKey<URI> SRC = AttributeKey.of(new QName("src"), URI.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(CONSTRUCT)) {
            return;
        }
        ElementCreator constructBuilder = registry.build(CONSTRUCT).setContentRequired(false);
        constructBuilder.addAttribute(TYPE);
        constructBuilder.addAttribute(SRC);
        constructBuilder.addAttribute(XML_LANG);
        registry.build(KEY);
    }

    public Content(ElementKey<?, ?> key) {
        super(key);
    }

    protected Content(ElementKey<?, ?> key, Element source) {
        super(key, source);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getLang() {
        return this.getAttributeValue(XML_LANG);
    }

    public void setLang(String lang) {
        this.setAttributeValue(XML_LANG, (Object)lang);
    }

    public ContentType getMimeType() {
        String type = this.getAttributeValue(TYPE);
        if (type == null) {
            return null;
        }
        return new ContentType(type);
    }

    public URI getSrc() {
        return this.getAttributeValue(SRC);
    }

    @Override
    protected Element narrow(ElementMetadata<?, ?> meta, ValidationContext vc) {
        if (!Content.class.equals(this.getClass())) {
            return this;
        }
        URI src = this.getSrc();
        if (src == null) {
            String type = this.getAttributeValue(TYPE);
            if (type == null || type.equals("text") || type.equals("html") || type.equals("xhtml")) {
                return this.adapt(this, meta, "text");
            }
            return this.adapt(this, meta, "other");
        }
        return this.adapt(this, meta, "out-of-line");
    }
}

