/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;

public abstract class SimulinkElement
extends SimulinkModelElement
implements ISimulinkElement {
    protected static final String ADD_BLOCK_MAKE_NAME_UNIQUE_ON = "add_block('?', '?', 'MakeNameUnique', 'on');";
    protected static final String HANDLE = "handle = ?;";
    protected static final String GET_SIMULINK_KIND = "get_param(handle, 'Type');";
    protected static final String GET_SIMULINK_TYPE = "get_param(handle, '%sType');";
    protected static final String GET_FULL_NAME = "getfullname(?);";
    protected Double handle = null;

    public SimulinkElement(SimulinkModel model, MatlabEngine engine, String type) throws MatlabRuntimeException {
        super(model, engine);
        try {
            String path = SimulinkUtil.getTypePathInModel(model, type);
            this.handle = (Double)engine.evalWithResult(ADD_BLOCK_MAKE_NAME_UNIQUE_ON, type, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatlabRuntimeException("Unable to create block element");
        }
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(SimulinkModel model, MatlabEngine engine, Double handle) throws MatlabRuntimeException {
        super(model, engine);
        if (handle == -1.0) {
            throw new MatlabRuntimeException("Bad handle -1");
        }
        this.handle = handle;
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(String path, SimulinkModel model, MatlabEngine engine) throws MatlabRuntimeException {
        super(model, engine);
        this.setHandle(path);
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(SimulinkModel model, MatlabEngine engine) {
        super(model, engine);
    }

    @Override
    public Object getProperty(String property) throws EolIllegalPropertyException {
        try {
            return this.engine.evalWithSetupAndResult(HANDLE, "get_param(handle, '?');", this.getHandle(), property);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            throw new EolIllegalPropertyException((Object)this, property, null, null);
        }
    }

    @Override
    public void setProperty(String property, Object value) throws EolIllegalPropertyException {
        try {
            String escaped = "?";
            if (value instanceof ISimulinkElement) {
                ISimulinkElement element = (ISimulinkElement)value;
                value = element.getHandle();
            } else {
                escaped = "'" + escaped + "'";
            }
            String cmd = "handle = ?; set_param(handle, '?', " + escaped + ");";
            this.engine.eval(cmd, this.getHandle(), property, value);
        }
        catch (MatlabException matlabException) {
            throw new EolIllegalPropertyException(value, property, null, null);
        }
    }

    @Override
    public Double getHandle() {
        return this.handle;
    }

    private void setHandle(String path) {
        this.handle = SimulinkUtil.getHandle(path, this.engine);
    }

    private void setType() throws MatlabException {
        if (this.handle != null) {
            this.superType = (String)this.engine.evalWithSetupAndResult(HANDLE, GET_SIMULINK_KIND, this.handle);
            String typeCmd = String.format(GET_SIMULINK_TYPE, this.superType);
            this.type = (String)this.engine.evalWithSetupAndResult(HANDLE, typeCmd, this.handle);
            try {
                TypeHelper.put(this.type, this.superType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getPath() {
        try {
            String path = (String)this.engine.evalWithResult(GET_FULL_NAME, this.handle);
            return path.replace("\n", " ");
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SimulinkElement && ((SimulinkElement)other).getHandle().equals(this.getHandle());
    }

    @Override
    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(TypeHelper.Kind.SIMULINK.getKind(), this.getType(), this.getSuperType());
    }

    public String toString() {
        return String.valueOf(this.getType()) + "[ Path=" + this.getPath() + ", handle=" + this.getHandle() + "]";
    }
}

